/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.ReceiptRule;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateReceiptRuleRequest
extends SesRequest
implements ToCopyableBuilder<Builder, CreateReceiptRuleRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleSetName").getter(CreateReceiptRuleRequest.getter(CreateReceiptRuleRequest::ruleSetName)).setter(CreateReceiptRuleRequest.setter(Builder::ruleSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()}).build();
    private static final SdkField<String> AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("After").getter(CreateReceiptRuleRequest.getter(CreateReceiptRuleRequest::after)).setter(CreateReceiptRuleRequest.setter(Builder::after)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()}).build();
    private static final SdkField<ReceiptRule> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(CreateReceiptRuleRequest.getter(CreateReceiptRuleRequest::rule)).setter(CreateReceiptRuleRequest.setter(Builder::rule)).constructor(ReceiptRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD, AFTER_FIELD, RULE_FIELD));
    private final String ruleSetName;
    private final String after;
    private final ReceiptRule rule;

    private CreateReceiptRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.after = builder.after;
        this.rule = builder.rule;
    }

    public final String ruleSetName() {
        return this.ruleSetName;
    }

    public final String after() {
        return this.after;
    }

    public final ReceiptRule rule() {
        return this.rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.after());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptRuleRequest)) {
            return false;
        }
        CreateReceiptRuleRequest other = (CreateReceiptRuleRequest)((Object)obj);
        return Objects.equals(this.ruleSetName(), other.ruleSetName()) && Objects.equals(this.after(), other.after()) && Objects.equals(this.rule(), other.rule());
    }

    public final String toString() {
        return ToString.builder((String)"CreateReceiptRuleRequest").add("RuleSetName", (Object)this.ruleSetName()).add("After", (Object)this.after()).add("Rule", (Object)this.rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleSetName": {
                return Optional.ofNullable(clazz.cast(this.ruleSetName()));
            }
            case "After": {
                return Optional.ofNullable(clazz.cast(this.after()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReceiptRuleRequest, T> g) {
        return obj -> g.apply((CreateReceiptRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String ruleSetName;
        private String after;
        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptRuleRequest model) {
            super(model);
            this.ruleSetName(model.ruleSetName);
            this.after(model.after);
            this.rule(model.rule);
        }

        public final String getRuleSetName() {
            return this.ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final String getAfter() {
            return this.after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        public final ReceiptRule.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptRuleRequest build() {
            return new CreateReceiptRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateReceiptRuleRequest> {
        public Builder ruleSetName(String var1);

        public Builder after(String var1);

        public Builder rule(ReceiptRule var1);

        default public Builder rule(Consumer<ReceiptRule.Builder> rule) {
            return this.rule((ReceiptRule)((ReceiptRule.Builder)ReceiptRule.builder().applyMutation(rule)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

