/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendBulkTemplatedEmailResponse extends SesResponse implements
        ToCopyableBuilder<SendBulkTemplatedEmailResponse.Builder, SendBulkTemplatedEmailResponse> {
    private static final SdkField<List<BulkEmailDestinationStatus>> STATUS_FIELD = SdkField
            .<List<BulkEmailDestinationStatus>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(SendBulkTemplatedEmailResponse::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BulkEmailDestinationStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(BulkEmailDestinationStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private final List<BulkEmailDestinationStatus> status;

    private SendBulkTemplatedEmailResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
     */
    public final List<BulkEmailDestinationStatus> status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? status() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailResponse)) {
            return false;
        }
        SendBulkTemplatedEmailResponse other = (SendBulkTemplatedEmailResponse) obj;
        return hasStatus() == other.hasStatus() && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendBulkTemplatedEmailResponse").add("Status", hasStatus() ? status() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBulkTemplatedEmailResponse, T> g) {
        return obj -> g.apply((SendBulkTemplatedEmailResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * </p>
         * 
         * @param status
         *        The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<BulkEmailDestinationStatus> status);

        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * </p>
         * 
         * @param status
         *        The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(BulkEmailDestinationStatus... status);

        /**
         * <p>
         * The unique message identifier returned from the <code>SendBulkTemplatedEmail</code> action.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BulkEmailDestinationStatus>.Builder}
         * avoiding the need to create one manually via {@link List<BulkEmailDestinationStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BulkEmailDestinationStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #status(List<BulkEmailDestinationStatus>)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link List<BulkEmailDestinationStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(List<BulkEmailDestinationStatus>)
         */
        Builder status(Consumer<BulkEmailDestinationStatus.Builder>... status);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<BulkEmailDestinationStatus> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailResponse model) {
            super(model);
            status(model.status);
        }

        public final List<BulkEmailDestinationStatus.Builder> getStatus() {
            List<BulkEmailDestinationStatus.Builder> result = BulkEmailDestinationStatusListCopier.copyToBuilder(this.status);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatus(Collection<BulkEmailDestinationStatus.BuilderImpl> status) {
            this.status = BulkEmailDestinationStatusListCopier.copyFromBuilder(status);
        }

        @Override
        @Transient
        public final Builder status(Collection<BulkEmailDestinationStatus> status) {
            this.status = BulkEmailDestinationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder status(BulkEmailDestinationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder status(Consumer<BulkEmailDestinationStatus.Builder>... status) {
            status(Stream.of(status).map(c -> BulkEmailDestinationStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SendBulkTemplatedEmailResponse build() {
            return new SendBulkTemplatedEmailResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
