/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.ReceiptFilterPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReceiptIpFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReceiptIpFilter> {
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(ReceiptIpFilter.getter(ReceiptIpFilter::policyAsString)).setter(ReceiptIpFilter.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Cidr").getter(ReceiptIpFilter.getter(ReceiptIpFilter::cidr)).setter(ReceiptIpFilter.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cidr").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, CIDR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policy;
    private final String cidr;

    private ReceiptIpFilter(BuilderImpl builder) {
        this.policy = builder.policy;
        this.cidr = builder.cidr;
    }

    public final ReceiptFilterPolicy policy() {
        return ReceiptFilterPolicy.fromValue(this.policy);
    }

    public final String policyAsString() {
        return this.policy;
    }

    public final String cidr() {
        return this.cidr;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptIpFilter)) {
            return false;
        }
        ReceiptIpFilter other = (ReceiptIpFilter)obj;
        return Objects.equals(this.policyAsString(), other.policyAsString()) && Objects.equals(this.cidr(), other.cidr());
    }

    public final String toString() {
        return ToString.builder((String)"ReceiptIpFilter").add("Policy", (Object)this.policyAsString()).add("Cidr", (Object)this.cidr()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policyAsString()));
            }
            case "Cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReceiptIpFilter, T> g) {
        return obj -> g.apply((ReceiptIpFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policy;
        private String cidr;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptIpFilter model) {
            this.policy(model.policy);
            this.cidr(model.cidr);
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        @Transient
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        @Transient
        public final Builder policy(ReceiptFilterPolicy policy) {
            this.policy(policy == null ? null : policy.toString());
            return this;
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        @Transient
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public ReceiptIpFilter build() {
            return new ReceiptIpFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReceiptIpFilter> {
        public Builder policy(String var1);

        public Builder policy(ReceiptFilterPolicy var1);

        public Builder cidr(String var1);
    }
}

