/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array that contains one or more Destinations, as well as the tags and replacement data associated with each of
 * those Destinations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkEmailDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<BulkEmailDestination.Builder, BulkEmailDestination> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .memberName("Destination").getter(getter(BulkEmailDestination::destination)).setter(setter(Builder::destination))
            .constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<MessageTag>> REPLACEMENT_TAGS_FIELD = SdkField
            .<List<MessageTag>> builder(MarshallingType.LIST)
            .memberName("ReplacementTags")
            .getter(getter(BulkEmailDestination::replacementTags))
            .setter(setter(Builder::replacementTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPLACEMENT_TEMPLATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplacementTemplateData").getter(getter(BulkEmailDestination::replacementTemplateData))
            .setter(setter(Builder::replacementTemplateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTemplateData").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            REPLACEMENT_TAGS_FIELD, REPLACEMENT_TEMPLATE_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final Destination destination;

    private final List<MessageTag> replacementTags;

    private final String replacementTemplateData;

    private BulkEmailDestination(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementTemplateData = builder.replacementTemplateData;
    }

    /**
     * Returns the value of the Destination property for this object.
     * 
     * @return The value of the Destination property for this object.
     */
    public final Destination destination() {
        return destination;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplacementTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReplacementTags() {
        return replacementTags != null && !(replacementTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using
     * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that you
     * can publish email sending events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplacementTags} method.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, to apply to an email that you send using
     *         <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so
     *         that you can publish email sending events.
     */
    public final List<MessageTag> replacementTags() {
        return replacementTags;
    }

    /**
     * <p>
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of
     * key-value pairs in which the keys correspond to replacement tags in the email template.
     * </p>
     * 
     * @return A list of replacement values to apply to the template. This parameter is a JSON object, typically
     *         consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public final String replacementTemplateData() {
        return replacementTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplacementTags() ? replacementTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replacementTemplateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailDestination)) {
            return false;
        }
        BulkEmailDestination other = (BulkEmailDestination) obj;
        return Objects.equals(destination(), other.destination()) && hasReplacementTags() == other.hasReplacementTags()
                && Objects.equals(replacementTags(), other.replacementTags())
                && Objects.equals(replacementTemplateData(), other.replacementTemplateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BulkEmailDestination").add("Destination", destination())
                .add("ReplacementTags", hasReplacementTags() ? replacementTags() : null)
                .add("ReplacementTemplateData", replacementTemplateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ReplacementTags":
            return Optional.ofNullable(clazz.cast(replacementTags()));
        case "ReplacementTemplateData":
            return Optional.ofNullable(clazz.cast(replacementTemplateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailDestination, T> g) {
        return obj -> g.apply((BulkEmailDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkEmailDestination> {
        /**
         * Sets the value of the Destination property for this object.
         *
         * @param destination
         *        The new value for the Destination property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * Sets the value of the Destination property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Destination.Builder} avoiding the need to
         * create one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using
         * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using
         *        <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define,
         *        so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(Collection<MessageTag> replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using
         * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using
         *        <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define,
         *        so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(MessageTag... replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using
         * <code>SendBulkTemplatedEmail</code>. Tags correspond to characteristics of the email that you define, so that
         * you can publish email sending events.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<MessageTag>.Builder} avoiding the
         * need to create one manually via {@link List<MessageTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MessageTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #replacementTags(List<MessageTag>)}.
         * 
         * @param replacementTags
         *        a consumer that will call methods on {@link List<MessageTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementTags(List<MessageTag>)
         */
        Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags);

        /**
         * <p>
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting
         * of key-value pairs in which the keys correspond to replacement tags in the email template.
         * </p>
         * 
         * @param replacementTemplateData
         *        A list of replacement values to apply to the template. This parameter is a JSON object, typically
         *        consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTemplateData(String replacementTemplateData);
    }

    static final class BuilderImpl implements Builder {
        private Destination destination;

        private List<MessageTag> replacementTags = DefaultSdkAutoConstructList.getInstance();

        private String replacementTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailDestination model) {
            destination(model.destination);
            replacementTags(model.replacementTags);
            replacementTemplateData(model.replacementTemplateData);
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        @Transient
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final List<MessageTag.Builder> getReplacementTags() {
            List<MessageTag.Builder> result = MessageTagListCopier.copyToBuilder(this.replacementTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        @Override
        @Transient
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replacementTags(MessageTag... replacementTags) {
            replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags) {
            replacementTags(Stream.of(replacementTags).map(c -> MessageTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReplacementTemplateData() {
            return replacementTemplateData;
        }

        public final void setReplacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
        }

        @Override
        @Transient
        public final Builder replacementTemplateData(String replacementTemplateData) {
            this.replacementTemplateData = replacementTemplateData;
            return this;
        }

        @Override
        public BulkEmailDestination build() {
            return new BulkEmailDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
