/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the details of the specified receipt rule set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReceiptRuleSetResponse extends SesResponse implements
        ToCopyableBuilder<DescribeReceiptRuleSetResponse.Builder, DescribeReceiptRuleSetResponse> {
    private static final SdkField<ReceiptRuleSetMetadata> METADATA_FIELD = SdkField
            .<ReceiptRuleSetMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(DescribeReceiptRuleSetResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(ReceiptRuleSetMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<List<ReceiptRule>> RULES_FIELD = SdkField
            .<List<ReceiptRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(DescribeReceiptRuleSetResponse::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReceiptRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReceiptRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, RULES_FIELD));

    private final ReceiptRuleSetMetadata metadata;

    private final List<ReceiptRule> rules;

    private DescribeReceiptRuleSetResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule set
     * was created.
     * </p>
     * 
     * @return The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the
     *         rule set was created.
     */
    public final ReceiptRuleSetMetadata metadata() {
        return metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the receipt rules that belong to the specified receipt rule set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return A list of the receipt rules that belong to the specified receipt rule set.
     */
    public final List<ReceiptRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReceiptRuleSetResponse)) {
            return false;
        }
        DescribeReceiptRuleSetResponse other = (DescribeReceiptRuleSetResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && hasRules() == other.hasRules()
                && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReceiptRuleSetResponse").add("Metadata", metadata())
                .add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReceiptRuleSetResponse, T> g) {
        return obj -> g.apply((DescribeReceiptRuleSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReceiptRuleSetResponse> {
        /**
         * <p>
         * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule
         * set was created.
         * </p>
         * 
         * @param metadata
         *        The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when
         *        the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(ReceiptRuleSetMetadata metadata);

        /**
         * <p>
         * The metadata for the receipt rule set, which consists of the rule set name and the timestamp of when the rule
         * set was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReceiptRuleSetMetadata.Builder} avoiding
         * the need to create one manually via {@link ReceiptRuleSetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptRuleSetMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #metadata(ReceiptRuleSetMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link ReceiptRuleSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(ReceiptRuleSetMetadata)
         */
        default Builder metadata(Consumer<ReceiptRuleSetMetadata.Builder> metadata) {
            return metadata(ReceiptRuleSetMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * A list of the receipt rules that belong to the specified receipt rule set.
         * </p>
         * 
         * @param rules
         *        A list of the receipt rules that belong to the specified receipt rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ReceiptRule> rules);

        /**
         * <p>
         * A list of the receipt rules that belong to the specified receipt rule set.
         * </p>
         * 
         * @param rules
         *        A list of the receipt rules that belong to the specified receipt rule set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ReceiptRule... rules);

        /**
         * <p>
         * A list of the receipt rules that belong to the specified receipt rule set.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReceiptRule>.Builder} avoiding the
         * need to create one manually via {@link List<ReceiptRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReceiptRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<ReceiptRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<ReceiptRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<ReceiptRule>)
         */
        Builder rules(Consumer<ReceiptRule.Builder>... rules);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private ReceiptRuleSetMetadata metadata;

        private List<ReceiptRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReceiptRuleSetResponse model) {
            super(model);
            metadata(model.metadata);
            rules(model.rules);
        }

        public final ReceiptRuleSetMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(ReceiptRuleSetMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(ReceiptRuleSetMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final List<ReceiptRule.Builder> getRules() {
            List<ReceiptRule.Builder> result = ReceiptRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ReceiptRule.BuilderImpl> rules) {
            this.rules = ReceiptRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<ReceiptRule> rules) {
            this.rules = ReceiptRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(ReceiptRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<ReceiptRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> ReceiptRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReceiptRuleSetResponse build() {
            return new DescribeReceiptRuleSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
