/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of IP address filters that exist under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListReceiptFiltersResponse extends SesResponse implements
        ToCopyableBuilder<ListReceiptFiltersResponse.Builder, ListReceiptFiltersResponse> {
    private static final SdkField<List<ReceiptFilter>> FILTERS_FIELD = SdkField
            .<List<ReceiptFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListReceiptFiltersResponse::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReceiptFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReceiptFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD));

    private final List<ReceiptFilter> filters;

    private ListReceiptFiltersResponse(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether to
     * allow or block mail from it.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A list of IP address filter data structures, which each consist of a name, an IP address range, and
     *         whether to allow or block mail from it.
     */
    public final List<ReceiptFilter> filters() {
        return filters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptFiltersResponse)) {
            return false;
        }
        ListReceiptFiltersResponse other = (ListReceiptFiltersResponse) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListReceiptFiltersResponse").add("Filters", hasFilters() ? filters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListReceiptFiltersResponse, T> g) {
        return obj -> g.apply((ListReceiptFiltersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListReceiptFiltersResponse> {
        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ReceiptFilter> filters);

        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * 
         * @param filters
         *        A list of IP address filter data structures, which each consist of a name, an IP address range, and
         *        whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ReceiptFilter... filters);

        /**
         * <p>
         * A list of IP address filter data structures, which each consist of a name, an IP address range, and whether
         * to allow or block mail from it.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ReceiptFilter>.Builder} avoiding the
         * need to create one manually via {@link List<ReceiptFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReceiptFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ReceiptFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ReceiptFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ReceiptFilter>)
         */
        Builder filters(Consumer<ReceiptFilter.Builder>... filters);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<ReceiptFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptFiltersResponse model) {
            super(model);
            filters(model.filters);
        }

        public final List<ReceiptFilter.Builder> getFilters() {
            List<ReceiptFilter.Builder> result = ReceiptFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<ReceiptFilter.BuilderImpl> filters) {
            this.filters = ReceiptFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<ReceiptFilter> filters) {
            this.filters = ReceiptFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(ReceiptFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<ReceiptFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ReceiptFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReceiptFiltersResponse build() {
            return new ListReceiptFiltersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
