/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTemplatesResponse extends SesResponse implements
        ToCopyableBuilder<ListTemplatesResponse.Builder, ListTemplatesResponse> {
    private static final SdkField<List<TemplateMetadata>> TEMPLATES_METADATA_FIELD = SdkField
            .<List<TemplateMetadata>> builder(MarshallingType.LIST)
            .memberName("TemplatesMetadata")
            .getter(getter(ListTemplatesResponse::templatesMetadata))
            .setter(setter(Builder::templatesMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplatesMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TemplateMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(TemplateMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTemplatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_METADATA_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<TemplateMetadata> templatesMetadata;

    private final String nextToken;

    private ListTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.templatesMetadata = builder.templatesMetadata;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TemplatesMetadata property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTemplatesMetadata() {
        return templatesMetadata != null && !(templatesMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array the contains the name and creation time stamp for each template in your Amazon SES account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTemplatesMetadata} method.
     * </p>
     * 
     * @return An array the contains the name and creation time stamp for each template in your Amazon SES account.
     */
    public final List<TemplateMetadata> templatesMetadata() {
        return templatesMetadata;
    }

    /**
     * <p>
     * A token indicating that there are additional email templates available to be listed. Pass this token to a
     * subsequent call to <code>ListTemplates</code> to retrieve the next 50 email templates.
     * </p>
     * 
     * @return A token indicating that there are additional email templates available to be listed. Pass this token to a
     *         subsequent call to <code>ListTemplates</code> to retrieve the next 50 email templates.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTemplatesMetadata() ? templatesMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTemplatesResponse)) {
            return false;
        }
        ListTemplatesResponse other = (ListTemplatesResponse) obj;
        return hasTemplatesMetadata() == other.hasTemplatesMetadata()
                && Objects.equals(templatesMetadata(), other.templatesMetadata())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTemplatesResponse")
                .add("TemplatesMetadata", hasTemplatesMetadata() ? templatesMetadata() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplatesMetadata":
            return Optional.ofNullable(clazz.cast(templatesMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTemplatesResponse, T> g) {
        return obj -> g.apply((ListTemplatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTemplatesResponse> {
        /**
         * <p>
         * An array the contains the name and creation time stamp for each template in your Amazon SES account.
         * </p>
         * 
         * @param templatesMetadata
         *        An array the contains the name and creation time stamp for each template in your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata);

        /**
         * <p>
         * An array the contains the name and creation time stamp for each template in your Amazon SES account.
         * </p>
         * 
         * @param templatesMetadata
         *        An array the contains the name and creation time stamp for each template in your Amazon SES account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templatesMetadata(TemplateMetadata... templatesMetadata);

        /**
         * <p>
         * An array the contains the name and creation time stamp for each template in your Amazon SES account.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TemplateMetadata>.Builder} avoiding
         * the need to create one manually via {@link List<TemplateMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TemplateMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #templatesMetadata(List<TemplateMetadata>)}.
         * 
         * @param templatesMetadata
         *        a consumer that will call methods on {@link List<TemplateMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #templatesMetadata(List<TemplateMetadata>)
         */
        Builder templatesMetadata(Consumer<TemplateMetadata.Builder>... templatesMetadata);

        /**
         * <p>
         * A token indicating that there are additional email templates available to be listed. Pass this token to a
         * subsequent call to <code>ListTemplates</code> to retrieve the next 50 email templates.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional email templates available to be listed. Pass this token
         *        to a subsequent call to <code>ListTemplates</code> to retrieve the next 50 email templates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private List<TemplateMetadata> templatesMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTemplatesResponse model) {
            super(model);
            templatesMetadata(model.templatesMetadata);
            nextToken(model.nextToken);
        }

        public final List<TemplateMetadata.Builder> getTemplatesMetadata() {
            List<TemplateMetadata.Builder> result = TemplateMetadataListCopier.copyToBuilder(this.templatesMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplatesMetadata(Collection<TemplateMetadata.BuilderImpl> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copyFromBuilder(templatesMetadata);
        }

        @Override
        @Transient
        public final Builder templatesMetadata(Collection<TemplateMetadata> templatesMetadata) {
            this.templatesMetadata = TemplateMetadataListCopier.copy(templatesMetadata);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder templatesMetadata(TemplateMetadata... templatesMetadata) {
            templatesMetadata(Arrays.asList(templatesMetadata));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder templatesMetadata(Consumer<TemplateMetadata.Builder>... templatesMetadata) {
            templatesMetadata(Stream.of(templatesMetadata).map(c -> TemplateMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTemplatesResponse build() {
            return new ListTemplatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
