/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSendQuotaResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetSendQuotaResponse> {
    private static final SdkField<Double> MAX24_HOUR_SEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Max24HourSend").getter(GetSendQuotaResponse.getter(GetSendQuotaResponse::max24HourSend)).setter(GetSendQuotaResponse.setter(Builder::max24HourSend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max24HourSend").build()}).build();
    private static final SdkField<Double> MAX_SEND_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxSendRate").getter(GetSendQuotaResponse.getter(GetSendQuotaResponse::maxSendRate)).setter(GetSendQuotaResponse.setter(Builder::maxSendRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSendRate").build()}).build();
    private static final SdkField<Double> SENT_LAST24_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SentLast24Hours").getter(GetSendQuotaResponse.getter(GetSendQuotaResponse::sentLast24Hours)).setter(GetSendQuotaResponse.setter(Builder::sentLast24Hours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SentLast24Hours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX24_HOUR_SEND_FIELD, MAX_SEND_RATE_FIELD, SENT_LAST24_HOURS_FIELD));
    private final Double max24HourSend;
    private final Double maxSendRate;
    private final Double sentLast24Hours;

    private GetSendQuotaResponse(BuilderImpl builder) {
        super(builder);
        this.max24HourSend = builder.max24HourSend;
        this.maxSendRate = builder.maxSendRate;
        this.sentLast24Hours = builder.sentLast24Hours;
    }

    public final Double max24HourSend() {
        return this.max24HourSend;
    }

    public final Double maxSendRate() {
        return this.maxSendRate;
    }

    public final Double sentLast24Hours() {
        return this.sentLast24Hours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.max24HourSend());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSendRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sentLast24Hours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendQuotaResponse)) {
            return false;
        }
        GetSendQuotaResponse other = (GetSendQuotaResponse)((Object)obj);
        return Objects.equals(this.max24HourSend(), other.max24HourSend()) && Objects.equals(this.maxSendRate(), other.maxSendRate()) && Objects.equals(this.sentLast24Hours(), other.sentLast24Hours());
    }

    public final String toString() {
        return ToString.builder((String)"GetSendQuotaResponse").add("Max24HourSend", (Object)this.max24HourSend()).add("MaxSendRate", (Object)this.maxSendRate()).add("SentLast24Hours", (Object)this.sentLast24Hours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Max24HourSend": {
                return Optional.ofNullable(clazz.cast(this.max24HourSend()));
            }
            case "MaxSendRate": {
                return Optional.ofNullable(clazz.cast(this.maxSendRate()));
            }
            case "SentLast24Hours": {
                return Optional.ofNullable(clazz.cast(this.sentLast24Hours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSendQuotaResponse, T> g) {
        return obj -> g.apply((GetSendQuotaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private Double max24HourSend;
        private Double maxSendRate;
        private Double sentLast24Hours;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendQuotaResponse model) {
            super(model);
            this.max24HourSend(model.max24HourSend);
            this.maxSendRate(model.maxSendRate);
            this.sentLast24Hours(model.sentLast24Hours);
        }

        public final Double getMax24HourSend() {
            return this.max24HourSend;
        }

        public final void setMax24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
        }

        @Override
        public final Builder max24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
            return this;
        }

        public final Double getMaxSendRate() {
            return this.maxSendRate;
        }

        public final void setMaxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
        }

        @Override
        public final Builder maxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
            return this;
        }

        public final Double getSentLast24Hours() {
            return this.sentLast24Hours;
        }

        public final void setSentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
        }

        @Override
        public final Builder sentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
            return this;
        }

        @Override
        public GetSendQuotaResponse build() {
            return new GetSendQuotaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSendQuotaResponse> {
        public Builder max24HourSend(Double var1);

        public Builder maxSendRate(Double var1);

        public Builder sentLast24Hours(Double var1);
    }
}

