/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ses.model.IdentityNotificationAttributes;
import software.amazon.awssdk.services.ses.model.NotificationAttributesCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdentityNotificationAttributesResponse
extends SesResponse
implements ToCopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
    private static final SdkField<Map<String, IdentityNotificationAttributes>> NOTIFICATION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("NotificationAttributes").getter(GetIdentityNotificationAttributesResponse.getter(GetIdentityNotificationAttributesResponse::notificationAttributes)).setter(GetIdentityNotificationAttributesResponse.setter(Builder::notificationAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdentityNotificationAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_ATTRIBUTES_FIELD));
    private final Map<String, IdentityNotificationAttributes> notificationAttributes;

    private GetIdentityNotificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.notificationAttributes = builder.notificationAttributes;
    }

    public final boolean hasNotificationAttributes() {
        return this.notificationAttributes != null && !(this.notificationAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, IdentityNotificationAttributes> notificationAttributes() {
        return this.notificationAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationAttributes() ? this.notificationAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesResponse)) {
            return false;
        }
        GetIdentityNotificationAttributesResponse other = (GetIdentityNotificationAttributesResponse)((Object)obj);
        return this.hasNotificationAttributes() == other.hasNotificationAttributes() && Objects.equals(this.notificationAttributes(), other.notificationAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdentityNotificationAttributesResponse").add("NotificationAttributes", this.hasNotificationAttributes() ? this.notificationAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NotificationAttributes": {
                return Optional.ofNullable(clazz.cast(this.notificationAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityNotificationAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityNotificationAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private Map<String, IdentityNotificationAttributes> notificationAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesResponse model) {
            super(model);
            this.notificationAttributes(model.notificationAttributes);
        }

        public final Map<String, IdentityNotificationAttributes.Builder> getNotificationAttributes() {
            Map<String, IdentityNotificationAttributes.Builder> result = NotificationAttributesCopier.copyToBuilder(this.notificationAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotificationAttributes(Map<String, IdentityNotificationAttributes.BuilderImpl> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copyFromBuilder(notificationAttributes);
        }

        @Override
        @Transient
        public final Builder notificationAttributes(Map<String, IdentityNotificationAttributes> notificationAttributes) {
            this.notificationAttributes = NotificationAttributesCopier.copy(notificationAttributes);
            return this;
        }

        @Override
        public GetIdentityNotificationAttributesResponse build() {
            return new GetIdentityNotificationAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdentityNotificationAttributesResponse> {
        public Builder notificationAttributes(Map<String, IdentityNotificationAttributes> var1);
    }
}

