/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the custom MAIL FROM attributes for a list of identities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityMailFromDomainAttributesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityMailFromDomainAttributesResponse.Builder, GetIdentityMailFromDomainAttributesResponse> {
    private static final SdkField<Map<String, IdentityMailFromDomainAttributes>> MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD = SdkField
            .<Map<String, IdentityMailFromDomainAttributes>> builder(MarshallingType.MAP)
            .memberName("MailFromDomainAttributes")
            .getter(getter(GetIdentityMailFromDomainAttributesResponse::mailFromDomainAttributes))
            .setter(setter(Builder::mailFromDomainAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomainAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IdentityMailFromDomainAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityMailFromDomainAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MAIL_FROM_DOMAIN_ATTRIBUTES_FIELD));

    private final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes;

    private GetIdentityMailFromDomainAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.mailFromDomainAttributes = builder.mailFromDomainAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the MailFromDomainAttributes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMailFromDomainAttributes() {
        return mailFromDomainAttributes != null && !(mailFromDomainAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of identities to custom MAIL FROM attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMailFromDomainAttributes} method.
     * </p>
     * 
     * @return A map of identities to custom MAIL FROM attributes.
     */
    public final Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes() {
        return mailFromDomainAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMailFromDomainAttributes() ? mailFromDomainAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityMailFromDomainAttributesResponse)) {
            return false;
        }
        GetIdentityMailFromDomainAttributesResponse other = (GetIdentityMailFromDomainAttributesResponse) obj;
        return hasMailFromDomainAttributes() == other.hasMailFromDomainAttributes()
                && Objects.equals(mailFromDomainAttributes(), other.mailFromDomainAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityMailFromDomainAttributesResponse")
                .add("MailFromDomainAttributes", hasMailFromDomainAttributes() ? mailFromDomainAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MailFromDomainAttributes":
            return Optional.ofNullable(clazz.cast(mailFromDomainAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityMailFromDomainAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityMailFromDomainAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityMailFromDomainAttributesResponse> {
        /**
         * <p>
         * A map of identities to custom MAIL FROM attributes.
         * </p>
         * 
         * @param mailFromDomainAttributes
         *        A map of identities to custom MAIL FROM attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityMailFromDomainAttributesResponse model) {
            super(model);
            mailFromDomainAttributes(model.mailFromDomainAttributes);
        }

        public final Map<String, IdentityMailFromDomainAttributes.Builder> getMailFromDomainAttributes() {
            Map<String, IdentityMailFromDomainAttributes.Builder> result = MailFromDomainAttributesCopier
                    .copyToBuilder(this.mailFromDomainAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMailFromDomainAttributes(
                Map<String, IdentityMailFromDomainAttributes.BuilderImpl> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copyFromBuilder(mailFromDomainAttributes);
        }

        @Override
        @Transient
        public final Builder mailFromDomainAttributes(Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributes) {
            this.mailFromDomainAttributes = MailFromDomainAttributesCopier.copy(mailFromDomainAttributes);
            return this;
        }

        @Override
        public GetIdentityMailFromDomainAttributesResponse build() {
            return new GetIdentityMailFromDomainAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
