/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.DefaultSesBaseClientBuilder;
import software.amazon.awssdk.services.ses.DefaultSesClient;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;
import software.amazon.awssdk.services.ses.SesServiceClientConfiguration;
import software.amazon.awssdk.services.ses.endpoints.SesEndpointProvider;

@SdkInternalApi
final class DefaultSesClientBuilder
extends DefaultSesBaseClientBuilder<SesClientBuilder, SesClient>
implements SesClientBuilder {
    DefaultSesClientBuilder() {
    }

    @Override
    public DefaultSesClientBuilder endpointProvider(SesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SesClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSesClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SesServiceClientConfiguration serviceClientConfiguration = SesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSesClient(serviceClientConfiguration, clientConfiguration);
    }
}

