/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to set the position of a receipt rule in a receipt rule set. You use receipt rule sets to
 * receive email with Amazon SES. For more information, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetReceiptRulePositionRequest extends SesRequest implements
        ToCopyableBuilder<SetReceiptRulePositionRequest.Builder, SetReceiptRulePositionRequest> {
    private static final SdkField<String> RULE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleSetName").getter(getter(SetReceiptRulePositionRequest::ruleSetName))
            .setter(setter(Builder::ruleSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleSetName").build()).build();

    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleName").getter(getter(SetReceiptRulePositionRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()).build();

    private static final SdkField<String> AFTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("After")
            .getter(getter(SetReceiptRulePositionRequest::after)).setter(setter(Builder::after))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("After").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_SET_NAME_FIELD,
            RULE_NAME_FIELD, AFTER_FIELD));

    private final String ruleSetName;

    private final String ruleName;

    private final String after;

    private SetReceiptRulePositionRequest(BuilderImpl builder) {
        super(builder);
        this.ruleSetName = builder.ruleSetName;
        this.ruleName = builder.ruleName;
        this.after = builder.after;
    }

    /**
     * <p>
     * The name of the receipt rule set that contains the receipt rule to reposition.
     * </p>
     * 
     * @return The name of the receipt rule set that contains the receipt rule to reposition.
     */
    public final String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * The name of the receipt rule to reposition.
     * </p>
     * 
     * @return The name of the receipt rule to reposition.
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The name of the receipt rule after which to place the specified receipt rule.
     * </p>
     * 
     * @return The name of the receipt rule after which to place the specified receipt rule.
     */
    public final String after() {
        return after;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleSetName());
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(after());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetReceiptRulePositionRequest)) {
            return false;
        }
        SetReceiptRulePositionRequest other = (SetReceiptRulePositionRequest) obj;
        return Objects.equals(ruleSetName(), other.ruleSetName()) && Objects.equals(ruleName(), other.ruleName())
                && Objects.equals(after(), other.after());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SetReceiptRulePositionRequest").add("RuleSetName", ruleSetName()).add("RuleName", ruleName())
                .add("After", after()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleSetName":
            return Optional.ofNullable(clazz.cast(ruleSetName()));
        case "RuleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "After":
            return Optional.ofNullable(clazz.cast(after()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetReceiptRulePositionRequest, T> g) {
        return obj -> g.apply((SetReceiptRulePositionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetReceiptRulePositionRequest> {
        /**
         * <p>
         * The name of the receipt rule set that contains the receipt rule to reposition.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set that contains the receipt rule to reposition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * The name of the receipt rule to reposition.
         * </p>
         * 
         * @param ruleName
         *        The name of the receipt rule to reposition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The name of the receipt rule after which to place the specified receipt rule.
         * </p>
         * 
         * @param after
         *        The name of the receipt rule after which to place the specified receipt rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder after(String after);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String ruleSetName;

        private String ruleName;

        private String after;

        private BuilderImpl() {
        }

        private BuilderImpl(SetReceiptRulePositionRequest model) {
            super(model);
            ruleSetName(model.ruleSetName);
            ruleName(model.ruleName);
            after(model.after);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getAfter() {
            return after;
        }

        public final void setAfter(String after) {
            this.after = after;
        }

        @Override
        public final Builder after(String after) {
            this.after = after;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetReceiptRulePositionRequest build() {
            return new SetReceiptRulePositionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
