/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the email, composed of a subject line and either an HTML part or a text-only part.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Template implements SdkPojo, Serializable, ToCopyableBuilder<Template.Builder, Template> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(Template::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> SUBJECT_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubjectPart").getter(getter(Template::subjectPart)).setter(setter(Builder::subjectPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectPart").build()).build();

    private static final SdkField<String> TEXT_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextPart").getter(getter(Template::textPart)).setter(setter(Builder::textPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextPart").build()).build();

    private static final SdkField<String> HTML_PART_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HtmlPart").getter(getter(Template::htmlPart)).setter(setter(Builder::htmlPart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HtmlPart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            SUBJECT_PART_FIELD, TEXT_PART_FIELD, HTML_PART_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TemplateName", TEMPLATE_NAME_FIELD);
                    put("SubjectPart", SUBJECT_PART_FIELD);
                    put("TextPart", TEXT_PART_FIELD);
                    put("HtmlPart", HTML_PART_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String templateName;

    private final String subjectPart;

    private final String textPart;

    private final String htmlPart;

    private Template(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.subjectPart = builder.subjectPart;
        this.textPart = builder.textPart;
        this.htmlPart = builder.htmlPart;
    }

    /**
     * <p>
     * The name of the template. You use this name when you send email using the <code>SendTemplatedEmail</code> or
     * <code>SendBulkTemplatedEmail</code> operations.
     * </p>
     * 
     * @return The name of the template. You use this name when you send email using the <code>SendTemplatedEmail</code>
     *         or <code>SendBulkTemplatedEmail</code> operations.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The subject line of the email.
     * </p>
     * 
     * @return The subject line of the email.
     */
    public final String subjectPart() {
        return subjectPart;
    }

    /**
     * <p>
     * The email body that is visible to recipients whose email clients do not display HTML content.
     * </p>
     * 
     * @return The email body that is visible to recipients whose email clients do not display HTML content.
     */
    public final String textPart() {
        return textPart;
    }

    /**
     * <p>
     * The HTML body of the email.
     * </p>
     * 
     * @return The HTML body of the email.
     */
    public final String htmlPart() {
        return htmlPart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(subjectPart());
        hashCode = 31 * hashCode + Objects.hashCode(textPart());
        hashCode = 31 * hashCode + Objects.hashCode(htmlPart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(subjectPart(), other.subjectPart())
                && Objects.equals(textPart(), other.textPart()) && Objects.equals(htmlPart(), other.htmlPart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Template").add("TemplateName", templateName()).add("SubjectPart", subjectPart())
                .add("TextPart", textPart()).add("HtmlPart", htmlPart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "SubjectPart":
            return Optional.ofNullable(clazz.cast(subjectPart()));
        case "TextPart":
            return Optional.ofNullable(clazz.cast(textPart()));
        case "HtmlPart":
            return Optional.ofNullable(clazz.cast(htmlPart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Template> {
        /**
         * <p>
         * The name of the template. You use this name when you send email using the <code>SendTemplatedEmail</code> or
         * <code>SendBulkTemplatedEmail</code> operations.
         * </p>
         * 
         * @param templateName
         *        The name of the template. You use this name when you send email using the
         *        <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The subject line of the email.
         * </p>
         * 
         * @param subjectPart
         *        The subject line of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectPart(String subjectPart);

        /**
         * <p>
         * The email body that is visible to recipients whose email clients do not display HTML content.
         * </p>
         * 
         * @param textPart
         *        The email body that is visible to recipients whose email clients do not display HTML content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPart(String textPart);

        /**
         * <p>
         * The HTML body of the email.
         * </p>
         * 
         * @param htmlPart
         *        The HTML body of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder htmlPart(String htmlPart);
    }

    static final class BuilderImpl implements Builder {
        private String templateName;

        private String subjectPart;

        private String textPart;

        private String htmlPart;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            templateName(model.templateName);
            subjectPart(model.subjectPart);
            textPart(model.textPart);
            htmlPart(model.htmlPart);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getSubjectPart() {
            return subjectPart;
        }

        public final void setSubjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
        }

        @Override
        public final Builder subjectPart(String subjectPart) {
            this.subjectPart = subjectPart;
            return this;
        }

        public final String getTextPart() {
            return textPart;
        }

        public final void setTextPart(String textPart) {
            this.textPart = textPart;
        }

        @Override
        public final Builder textPart(String textPart) {
            this.textPart = textPart;
            return this;
        }

        public final String getHtmlPart() {
            return htmlPart;
        }

        public final void setHtmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
        }

        @Override
        public final Builder htmlPart(String htmlPart) {
            this.htmlPart = htmlPart;
            return this;
        }

        @Override
        public Template build() {
            return new Template(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
