/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update the tracking options for a configuration set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConfigurationSetTrackingOptionsRequest extends SesRequest implements
        ToCopyableBuilder<UpdateConfigurationSetTrackingOptionsRequest.Builder, UpdateConfigurationSetTrackingOptionsRequest> {
    private static final SdkField<String> CONFIGURATION_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateConfigurationSetTrackingOptionsRequest::configurationSetName))
            .setter(setter(Builder::configurationSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSetName").build())
            .build();

    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField
            .<TrackingOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateConfigurationSetTrackingOptionsRequest::trackingOptions))
            .setter(setter(Builder::trackingOptions)).constructor(TrackingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_NAME_FIELD,
            TRACKING_OPTIONS_FIELD));

    private final String configurationSetName;

    private final TrackingOptions trackingOptions;

    private UpdateConfigurationSetTrackingOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSetName = builder.configurationSetName;
        this.trackingOptions = builder.trackingOptions;
    }

    /**
     * <p>
     * The name of the configuration set for which you want to update the custom tracking domain.
     * </p>
     * 
     * @return The name of the configuration set for which you want to update the custom tracking domain.
     */
    public String configurationSetName() {
        return configurationSetName;
    }

    /**
     * Returns the value of the TrackingOptions property for this object.
     * 
     * @return The value of the TrackingOptions property for this object.
     */
    public TrackingOptions trackingOptions() {
        return trackingOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSetName());
        hashCode = 31 * hashCode + Objects.hashCode(trackingOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationSetTrackingOptionsRequest)) {
            return false;
        }
        UpdateConfigurationSetTrackingOptionsRequest other = (UpdateConfigurationSetTrackingOptionsRequest) obj;
        return Objects.equals(configurationSetName(), other.configurationSetName())
                && Objects.equals(trackingOptions(), other.trackingOptions());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateConfigurationSetTrackingOptionsRequest")
                .add("ConfigurationSetName", configurationSetName()).add("TrackingOptions", trackingOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSetName":
            return Optional.ofNullable(clazz.cast(configurationSetName()));
        case "TrackingOptions":
            return Optional.ofNullable(clazz.cast(trackingOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationSetTrackingOptionsRequest, T> g) {
        return obj -> g.apply((UpdateConfigurationSetTrackingOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateConfigurationSetTrackingOptionsRequest> {
        /**
         * <p>
         * The name of the configuration set for which you want to update the custom tracking domain.
         * </p>
         * 
         * @param configurationSetName
         *        The name of the configuration set for which you want to update the custom tracking domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSetName(String configurationSetName);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * @param trackingOptions
         *        The new value for the TrackingOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingOptions(TrackingOptions trackingOptions);

        /**
         * Sets the value of the TrackingOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link TrackingOptions.Builder} avoiding the need to
         * create one manually via {@link TrackingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TrackingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #trackingOptions(TrackingOptions)}.
         * 
         * @param trackingOptions
         *        a consumer that will call methods on {@link TrackingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trackingOptions(TrackingOptions)
         */
        default Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return trackingOptions(TrackingOptions.builder().applyMutation(trackingOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private String configurationSetName;

        private TrackingOptions trackingOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationSetTrackingOptionsRequest model) {
            super(model);
            configurationSetName(model.configurationSetName);
            trackingOptions(model.trackingOptions);
        }

        public final String getConfigurationSetName() {
            return configurationSetName;
        }

        @Override
        public final Builder configurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
            return this;
        }

        public final void setConfigurationSetName(String configurationSetName) {
            this.configurationSetName = configurationSetName;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return trackingOptions != null ? trackingOptions.toBuilder() : null;
        }

        @Override
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConfigurationSetTrackingOptionsRequest build() {
            return new UpdateConfigurationSetTrackingOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
