/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.model.ListIdentitiesRequest;
import software.amazon.awssdk.services.ses.model.ListIdentitiesResponse;

public class ListIdentitiesPublisher
implements SdkPublisher<ListIdentitiesResponse> {
    private final SesAsyncClient client;
    private final ListIdentitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdentitiesPublisher(SesAsyncClient client, ListIdentitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdentitiesPublisher(SesAsyncClient client, ListIdentitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdentitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdentitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> identities() {
        Function<ListIdentitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.identities() != null) {
                return response.identities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdentitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListIdentitiesPublisher resume(ListIdentitiesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListIdentitiesPublisher(this.client, (ListIdentitiesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListIdentitiesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListIdentitiesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListIdentitiesResponseFetcher
    implements AsyncPageFetcher<ListIdentitiesResponse> {
        private ListIdentitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdentitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdentitiesResponse> nextPage(ListIdentitiesResponse previousPage) {
            if (previousPage == null) {
                return ListIdentitiesPublisher.this.client.listIdentities(ListIdentitiesPublisher.this.firstRequest);
            }
            return ListIdentitiesPublisher.this.client.listIdentities((ListIdentitiesRequest)((Object)ListIdentitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

