/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the status of Amazon SES Easy DKIM signing for an identity. For domain identities, this response also
 * contains the DKIM tokens that are required for Easy DKIM signing, and whether Amazon SES successfully verified that
 * these tokens were published.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityDkimAttributesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityDkimAttributesResponse.Builder, GetIdentityDkimAttributesResponse> {
    private static final SdkField<Map<String, IdentityDkimAttributes>> DKIM_ATTRIBUTES_FIELD = SdkField
            .<Map<String, IdentityDkimAttributes>> builder(MarshallingType.MAP)
            .getter(getter(GetIdentityDkimAttributesResponse::dkimAttributes))
            .setter(setter(Builder::dkimAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<IdentityDkimAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityDkimAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_ATTRIBUTES_FIELD));

    private final Map<String, IdentityDkimAttributes> dkimAttributes;

    private GetIdentityDkimAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dkimAttributes = builder.dkimAttributes;
    }

    /**
     * <p>
     * The DKIM attributes for an email address or a domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The DKIM attributes for an email address or a domain.
     */
    public Map<String, IdentityDkimAttributes> dkimAttributes() {
        return dkimAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dkimAttributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityDkimAttributesResponse)) {
            return false;
        }
        GetIdentityDkimAttributesResponse other = (GetIdentityDkimAttributesResponse) obj;
        return Objects.equals(dkimAttributes(), other.dkimAttributes());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIdentityDkimAttributesResponse").add("DkimAttributes", dkimAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DkimAttributes":
            return Optional.ofNullable(clazz.cast(dkimAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityDkimAttributesResponse, T> g) {
        return obj -> g.apply((GetIdentityDkimAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIdentityDkimAttributesResponse> {
        /**
         * <p>
         * The DKIM attributes for an email address or a domain.
         * </p>
         * 
         * @param dkimAttributes
         *        The DKIM attributes for an email address or a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimAttributes(Map<String, IdentityDkimAttributes> dkimAttributes);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, IdentityDkimAttributes> dkimAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityDkimAttributesResponse model) {
            super(model);
            dkimAttributes(model.dkimAttributes);
        }

        public final Map<String, IdentityDkimAttributes.Builder> getDkimAttributes() {
            return dkimAttributes != null ? CollectionUtils.mapValues(dkimAttributes, IdentityDkimAttributes::toBuilder) : null;
        }

        @Override
        public final Builder dkimAttributes(Map<String, IdentityDkimAttributes> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copy(dkimAttributes);
            return this;
        }

        public final void setDkimAttributes(Map<String, IdentityDkimAttributes.BuilderImpl> dkimAttributes) {
            this.dkimAttributes = DkimAttributesCopier.copyFromBuilder(dkimAttributes);
        }

        @Override
        public GetIdentityDkimAttributesResponse build() {
            return new GetIdentityDkimAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
