/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the notification attributes of an identity, including whether an identity has Amazon Simple Notification
 * Service (Amazon SNS) topics set for bounce, complaint, and/or delivery notifications, and whether feedback forwarding
 * is enabled for bounce and complaint notifications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityNotificationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityNotificationAttributes.Builder, IdentityNotificationAttributes> {
    private static final SdkField<String> BOUNCE_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BounceTopic").getter(getter(IdentityNotificationAttributes::bounceTopic))
            .setter(setter(Builder::bounceTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BounceTopic").build()).build();

    private static final SdkField<String> COMPLAINT_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplaintTopic").getter(getter(IdentityNotificationAttributes::complaintTopic))
            .setter(setter(Builder::complaintTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplaintTopic").build()).build();

    private static final SdkField<String> DELIVERY_TOPIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryTopic").getter(getter(IdentityNotificationAttributes::deliveryTopic))
            .setter(setter(Builder::deliveryTopic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryTopic").build()).build();

    private static final SdkField<Boolean> FORWARDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForwardingEnabled").getter(getter(IdentityNotificationAttributes::forwardingEnabled))
            .setter(setter(Builder::forwardingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingEnabled").build()).build();

    private static final SdkField<Boolean> HEADERS_IN_BOUNCE_NOTIFICATIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HeadersInBounceNotificationsEnabled")
            .getter(getter(IdentityNotificationAttributes::headersInBounceNotificationsEnabled))
            .setter(setter(Builder::headersInBounceNotificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HeadersInBounceNotificationsEnabled").build()).build();

    private static final SdkField<Boolean> HEADERS_IN_COMPLAINT_NOTIFICATIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HeadersInComplaintNotificationsEnabled")
            .getter(getter(IdentityNotificationAttributes::headersInComplaintNotificationsEnabled))
            .setter(setter(Builder::headersInComplaintNotificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HeadersInComplaintNotificationsEnabled").build()).build();

    private static final SdkField<Boolean> HEADERS_IN_DELIVERY_NOTIFICATIONS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HeadersInDeliveryNotificationsEnabled")
            .getter(getter(IdentityNotificationAttributes::headersInDeliveryNotificationsEnabled))
            .setter(setter(Builder::headersInDeliveryNotificationsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("HeadersInDeliveryNotificationsEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOUNCE_TOPIC_FIELD,
            COMPLAINT_TOPIC_FIELD, DELIVERY_TOPIC_FIELD, FORWARDING_ENABLED_FIELD, HEADERS_IN_BOUNCE_NOTIFICATIONS_ENABLED_FIELD,
            HEADERS_IN_COMPLAINT_NOTIFICATIONS_ENABLED_FIELD, HEADERS_IN_DELIVERY_NOTIFICATIONS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bounceTopic;

    private final String complaintTopic;

    private final String deliveryTopic;

    private final Boolean forwardingEnabled;

    private final Boolean headersInBounceNotificationsEnabled;

    private final Boolean headersInComplaintNotificationsEnabled;

    private final Boolean headersInDeliveryNotificationsEnabled;

    private IdentityNotificationAttributes(BuilderImpl builder) {
        this.bounceTopic = builder.bounceTopic;
        this.complaintTopic = builder.complaintTopic;
        this.deliveryTopic = builder.deliveryTopic;
        this.forwardingEnabled = builder.forwardingEnabled;
        this.headersInBounceNotificationsEnabled = builder.headersInBounceNotificationsEnabled;
        this.headersInComplaintNotificationsEnabled = builder.headersInComplaintNotificationsEnabled;
        this.headersInDeliveryNotificationsEnabled = builder.headersInDeliveryNotificationsEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce notifications.
     */
    public final String bounceTopic() {
        return bounceTopic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint
     *         notifications.
     */
    public final String complaintTopic() {
        return complaintTopic;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery notifications.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery notifications.
     */
    public final String deliveryTopic() {
        return deliveryTopic;
    }

    /**
     * <p>
     * Describes whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code> indicates
     * that Amazon SES forwards bounce and complaint notifications as email, while <code>false</code> indicates that
     * bounce and complaint notifications are published only to the specified bounce and complaint Amazon SNS topics.
     * </p>
     * 
     * @return Describes whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code>
     *         indicates that Amazon SES forwards bounce and complaint notifications as email, while <code>false</code>
     *         indicates that bounce and complaint notifications are published only to the specified bounce and
     *         complaint Amazon SNS topics.
     */
    public final Boolean forwardingEnabled() {
        return forwardingEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES includes headers in bounce
     * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in bounce
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES includes headers in bounce
     *         notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in
     *         bounce notifications.
     */
    public final Boolean headersInBounceNotificationsEnabled() {
        return headersInBounceNotificationsEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES includes headers in complaint
     * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in complaint
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES includes headers in
     *         complaint notifications, and a value of <code>false</code> specifies that Amazon SES does not include
     *         headers in complaint notifications.
     */
    public final Boolean headersInComplaintNotificationsEnabled() {
        return headersInComplaintNotificationsEnabled;
    }

    /**
     * <p>
     * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     * <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES includes headers in delivery
     * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in delivery
     * notifications.
     * </p>
     * 
     * @return Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
     *         <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES includes headers in
     *         delivery notifications, and a value of <code>false</code> specifies that Amazon SES does not include
     *         headers in delivery notifications.
     */
    public final Boolean headersInDeliveryNotificationsEnabled() {
        return headersInDeliveryNotificationsEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bounceTopic());
        hashCode = 31 * hashCode + Objects.hashCode(complaintTopic());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryTopic());
        hashCode = 31 * hashCode + Objects.hashCode(forwardingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInBounceNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInComplaintNotificationsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(headersInDeliveryNotificationsEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityNotificationAttributes)) {
            return false;
        }
        IdentityNotificationAttributes other = (IdentityNotificationAttributes) obj;
        return Objects.equals(bounceTopic(), other.bounceTopic()) && Objects.equals(complaintTopic(), other.complaintTopic())
                && Objects.equals(deliveryTopic(), other.deliveryTopic())
                && Objects.equals(forwardingEnabled(), other.forwardingEnabled())
                && Objects.equals(headersInBounceNotificationsEnabled(), other.headersInBounceNotificationsEnabled())
                && Objects.equals(headersInComplaintNotificationsEnabled(), other.headersInComplaintNotificationsEnabled())
                && Objects.equals(headersInDeliveryNotificationsEnabled(), other.headersInDeliveryNotificationsEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityNotificationAttributes").add("BounceTopic", bounceTopic())
                .add("ComplaintTopic", complaintTopic()).add("DeliveryTopic", deliveryTopic())
                .add("ForwardingEnabled", forwardingEnabled())
                .add("HeadersInBounceNotificationsEnabled", headersInBounceNotificationsEnabled())
                .add("HeadersInComplaintNotificationsEnabled", headersInComplaintNotificationsEnabled())
                .add("HeadersInDeliveryNotificationsEnabled", headersInDeliveryNotificationsEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BounceTopic":
            return Optional.ofNullable(clazz.cast(bounceTopic()));
        case "ComplaintTopic":
            return Optional.ofNullable(clazz.cast(complaintTopic()));
        case "DeliveryTopic":
            return Optional.ofNullable(clazz.cast(deliveryTopic()));
        case "ForwardingEnabled":
            return Optional.ofNullable(clazz.cast(forwardingEnabled()));
        case "HeadersInBounceNotificationsEnabled":
            return Optional.ofNullable(clazz.cast(headersInBounceNotificationsEnabled()));
        case "HeadersInComplaintNotificationsEnabled":
            return Optional.ofNullable(clazz.cast(headersInComplaintNotificationsEnabled()));
        case "HeadersInDeliveryNotificationsEnabled":
            return Optional.ofNullable(clazz.cast(headersInDeliveryNotificationsEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BounceTopic", BOUNCE_TOPIC_FIELD);
        map.put("ComplaintTopic", COMPLAINT_TOPIC_FIELD);
        map.put("DeliveryTopic", DELIVERY_TOPIC_FIELD);
        map.put("ForwardingEnabled", FORWARDING_ENABLED_FIELD);
        map.put("HeadersInBounceNotificationsEnabled", HEADERS_IN_BOUNCE_NOTIFICATIONS_ENABLED_FIELD);
        map.put("HeadersInComplaintNotificationsEnabled", HEADERS_IN_COMPLAINT_NOTIFICATIONS_ENABLED_FIELD);
        map.put("HeadersInDeliveryNotificationsEnabled", HEADERS_IN_DELIVERY_NOTIFICATIONS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityNotificationAttributes, T> g) {
        return obj -> g.apply((IdentityNotificationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityNotificationAttributes> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce notifications.
         * </p>
         * 
         * @param bounceTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes bounce
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bounceTopic(String bounceTopic);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint notifications.
         * </p>
         * 
         * @param complaintTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes complaint
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complaintTopic(String complaintTopic);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery notifications.
         * </p>
         * 
         * @param deliveryTopic
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES publishes delivery
         *        notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryTopic(String deliveryTopic);

        /**
         * <p>
         * Describes whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code>
         * indicates that Amazon SES forwards bounce and complaint notifications as email, while <code>false</code>
         * indicates that bounce and complaint notifications are published only to the specified bounce and complaint
         * Amazon SNS topics.
         * </p>
         * 
         * @param forwardingEnabled
         *        Describes whether Amazon SES forwards bounce and complaint notifications as email. <code>true</code>
         *        indicates that Amazon SES forwards bounce and complaint notifications as email, while
         *        <code>false</code> indicates that bounce and complaint notifications are published only to the
         *        specified bounce and complaint Amazon SNS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forwardingEnabled(Boolean forwardingEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES includes headers in bounce
         * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in bounce
         * notifications.
         * </p>
         * 
         * @param headersInBounceNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Bounce</code>. A value of <code>true</code> specifies that Amazon SES includes headers in bounce
         *        notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in
         *        bounce notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES includes headers in complaint
         * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in
         * complaint notifications.
         * </p>
         * 
         * @param headersInComplaintNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Complaint</code>. A value of <code>true</code> specifies that Amazon SES includes headers in
         *        complaint notifications, and a value of <code>false</code> specifies that Amazon SES does not include
         *        headers in complaint notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled);

        /**
         * <p>
         * Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         * <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES includes headers in delivery
         * notifications, and a value of <code>false</code> specifies that Amazon SES does not include headers in
         * delivery notifications.
         * </p>
         * 
         * @param headersInDeliveryNotificationsEnabled
         *        Describes whether Amazon SES includes the original email headers in Amazon SNS notifications of type
         *        <code>Delivery</code>. A value of <code>true</code> specifies that Amazon SES includes headers in
         *        delivery notifications, and a value of <code>false</code> specifies that Amazon SES does not include
         *        headers in delivery notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String bounceTopic;

        private String complaintTopic;

        private String deliveryTopic;

        private Boolean forwardingEnabled;

        private Boolean headersInBounceNotificationsEnabled;

        private Boolean headersInComplaintNotificationsEnabled;

        private Boolean headersInDeliveryNotificationsEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityNotificationAttributes model) {
            bounceTopic(model.bounceTopic);
            complaintTopic(model.complaintTopic);
            deliveryTopic(model.deliveryTopic);
            forwardingEnabled(model.forwardingEnabled);
            headersInBounceNotificationsEnabled(model.headersInBounceNotificationsEnabled);
            headersInComplaintNotificationsEnabled(model.headersInComplaintNotificationsEnabled);
            headersInDeliveryNotificationsEnabled(model.headersInDeliveryNotificationsEnabled);
        }

        public final String getBounceTopic() {
            return bounceTopic;
        }

        public final void setBounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
        }

        @Override
        public final Builder bounceTopic(String bounceTopic) {
            this.bounceTopic = bounceTopic;
            return this;
        }

        public final String getComplaintTopic() {
            return complaintTopic;
        }

        public final void setComplaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
        }

        @Override
        public final Builder complaintTopic(String complaintTopic) {
            this.complaintTopic = complaintTopic;
            return this;
        }

        public final String getDeliveryTopic() {
            return deliveryTopic;
        }

        public final void setDeliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
        }

        @Override
        public final Builder deliveryTopic(String deliveryTopic) {
            this.deliveryTopic = deliveryTopic;
            return this;
        }

        public final Boolean getForwardingEnabled() {
            return forwardingEnabled;
        }

        public final void setForwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
        }

        @Override
        public final Builder forwardingEnabled(Boolean forwardingEnabled) {
            this.forwardingEnabled = forwardingEnabled;
            return this;
        }

        public final Boolean getHeadersInBounceNotificationsEnabled() {
            return headersInBounceNotificationsEnabled;
        }

        public final void setHeadersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
        }

        @Override
        public final Builder headersInBounceNotificationsEnabled(Boolean headersInBounceNotificationsEnabled) {
            this.headersInBounceNotificationsEnabled = headersInBounceNotificationsEnabled;
            return this;
        }

        public final Boolean getHeadersInComplaintNotificationsEnabled() {
            return headersInComplaintNotificationsEnabled;
        }

        public final void setHeadersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
        }

        @Override
        public final Builder headersInComplaintNotificationsEnabled(Boolean headersInComplaintNotificationsEnabled) {
            this.headersInComplaintNotificationsEnabled = headersInComplaintNotificationsEnabled;
            return this;
        }

        public final Boolean getHeadersInDeliveryNotificationsEnabled() {
            return headersInDeliveryNotificationsEnabled;
        }

        public final void setHeadersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
        }

        @Override
        public final Builder headersInDeliveryNotificationsEnabled(Boolean headersInDeliveryNotificationsEnabled) {
            this.headersInDeliveryNotificationsEnabled = headersInDeliveryNotificationsEnabled;
            return this;
        }

        @Override
        public IdentityNotificationAttributes build() {
            return new IdentityNotificationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
