/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the requested sending authorization policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityPoliciesResponse extends SesResponse implements
        ToCopyableBuilder<GetIdentityPoliciesResponse.Builder, GetIdentityPoliciesResponse> {
    private static final SdkField<Map<String, String>> POLICIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Policies")
            .getter(getter(GetIdentityPoliciesResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, String> policies;

    private GetIdentityPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Policies property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicies() {
        return policies != null && !(policies instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of policy names to policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicies} method.
     * </p>
     * 
     * @return A map of policy names to policies.
     */
    public final Map<String, String> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicies() ? policies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesResponse)) {
            return false;
        }
        GetIdentityPoliciesResponse other = (GetIdentityPoliciesResponse) obj;
        return hasPolicies() == other.hasPolicies() && Objects.equals(policies(), other.policies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityPoliciesResponse").add("Policies", hasPolicies() ? policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policies":
            return Optional.ofNullable(clazz.cast(policies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Policies", POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityPoliciesResponse, T> g) {
        return obj -> g.apply((GetIdentityPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIdentityPoliciesResponse> {
        /**
         * <p>
         * A map of policy names to policies.
         * </p>
         * 
         * @param policies
         *        A map of policy names to policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Map<String, String> policies);
    }

    static final class BuilderImpl extends SesResponse.BuilderImpl implements Builder {
        private Map<String, String> policies = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesResponse model) {
            super(model);
            policies(model.policies);
        }

        public final Map<String, String> getPolicies() {
            if (policies instanceof SdkAutoConstructMap) {
                return null;
            }
            return policies;
        }

        public final void setPolicies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
        }

        @Override
        public final Builder policies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
            return this;
        }

        @Override
        public GetIdentityPoliciesResponse build() {
            return new GetIdentityPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
