/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a configuration set. Configuration sets enable you to publish email sending events.
 * For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfigurationSetRequest extends SesRequest implements
        ToCopyableBuilder<CreateConfigurationSetRequest.Builder, CreateConfigurationSetRequest> {
    private static final SdkField<ConfigurationSet> CONFIGURATION_SET_FIELD = SdkField
            .<ConfigurationSet> builder(MarshallingType.SDK_POJO).getter(getter(CreateConfigurationSetRequest::configurationSet))
            .setter(setter(Builder::configurationSet)).constructor(ConfigurationSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_FIELD));

    private final ConfigurationSet configurationSet;

    private CreateConfigurationSetRequest(BuilderImpl builder) {
        super(builder);
        this.configurationSet = builder.configurationSet;
    }

    /**
     * <p>
     * A data structure that contains the name of the configuration set.
     * </p>
     * 
     * @return A data structure that contains the name of the configuration set.
     */
    public ConfigurationSet configurationSet() {
        return configurationSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationSet());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfigurationSetRequest)) {
            return false;
        }
        CreateConfigurationSetRequest other = (CreateConfigurationSetRequest) obj;
        return Objects.equals(configurationSet(), other.configurationSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateConfigurationSetRequest").add("ConfigurationSet", configurationSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationSet":
            return Optional.ofNullable(clazz.cast(configurationSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfigurationSetRequest, T> g) {
        return obj -> g.apply((CreateConfigurationSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConfigurationSetRequest> {
        /**
         * <p>
         * A data structure that contains the name of the configuration set.
         * </p>
         * 
         * @param configurationSet
         *        A data structure that contains the name of the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSet(ConfigurationSet configurationSet);

        /**
         * <p>
         * A data structure that contains the name of the configuration set.
         * </p>
         * This is a convenience that creates an instance of the {@link ConfigurationSet.Builder} avoiding the need to
         * create one manually via {@link ConfigurationSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConfigurationSet.Builder#build()} is called immediately and its
         * result is passed to {@link #configurationSet(ConfigurationSet)}.
         * 
         * @param configurationSet
         *        a consumer that will call methods on {@link ConfigurationSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSet(ConfigurationSet)
         */
        default Builder configurationSet(Consumer<ConfigurationSet.Builder> configurationSet) {
            return configurationSet(ConfigurationSet.builder().applyMutation(configurationSet).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private ConfigurationSet configurationSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfigurationSetRequest model) {
            super(model);
            configurationSet(model.configurationSet);
        }

        public final ConfigurationSet.Builder getConfigurationSet() {
            return configurationSet != null ? configurationSet.toBuilder() : null;
        }

        @Override
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final void setConfigurationSet(ConfigurationSet.BuilderImpl configurationSet) {
            this.configurationSet = configurationSet != null ? configurationSet.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfigurationSetRequest build() {
            return new CreateConfigurationSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
