/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifyDomainDkimRequest
extends SesRequest
implements ToCopyableBuilder<Builder, VerifyDomainDkimRequest> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(VerifyDomainDkimRequest.getter(VerifyDomainDkimRequest::domain)).setter(VerifyDomainDkimRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD));
    private final String domain;

    private VerifyDomainDkimRequest(BuilderImpl builder) {
        super(builder);
        this.domain = builder.domain;
    }

    public String domain() {
        return this.domain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifyDomainDkimRequest)) {
            return false;
        }
        VerifyDomainDkimRequest other = (VerifyDomainDkimRequest)((Object)obj);
        return Objects.equals(this.domain(), other.domain());
    }

    public String toString() {
        return ToString.builder((String)"VerifyDomainDkimRequest").add("Domain", (Object)this.domain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifyDomainDkimRequest, T> g) {
        return obj -> g.apply((VerifyDomainDkimRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String domain;

        private BuilderImpl() {
        }

        private BuilderImpl(VerifyDomainDkimRequest model) {
            super(model);
            this.domain(model.domain);
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VerifyDomainDkimRequest build() {
            return new VerifyDomainDkimRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, VerifyDomainDkimRequest> {
        public Builder domain(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

