/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a new IP address filter. You use IP address filters when you receive email with Amazon
 * SES. For more information, see the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateReceiptFilterRequest extends SesRequest implements
        ToCopyableBuilder<CreateReceiptFilterRequest.Builder, CreateReceiptFilterRequest> {
    private static final SdkField<ReceiptFilter> FILTER_FIELD = SdkField.<ReceiptFilter> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateReceiptFilterRequest::filter)).setter(setter(Builder::filter))
            .constructor(ReceiptFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD));

    private final ReceiptFilter filter;

    private CreateReceiptFilterRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
    }

    /**
     * <p>
     * A data structure that describes the IP address filter to create, which consists of a name, an IP address range,
     * and whether to allow or block mail from it.
     * </p>
     * 
     * @return A data structure that describes the IP address filter to create, which consists of a name, an IP address
     *         range, and whether to allow or block mail from it.
     */
    public ReceiptFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReceiptFilterRequest)) {
            return false;
        }
        CreateReceiptFilterRequest other = (CreateReceiptFilterRequest) obj;
        return Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateReceiptFilterRequest").add("Filter", filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateReceiptFilterRequest, T> g) {
        return obj -> g.apply((CreateReceiptFilterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateReceiptFilterRequest> {
        /**
         * <p>
         * A data structure that describes the IP address filter to create, which consists of a name, an IP address
         * range, and whether to allow or block mail from it.
         * </p>
         * 
         * @param filter
         *        A data structure that describes the IP address filter to create, which consists of a name, an IP
         *        address range, and whether to allow or block mail from it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ReceiptFilter filter);

        /**
         * <p>
         * A data structure that describes the IP address filter to create, which consists of a name, an IP address
         * range, and whether to allow or block mail from it.
         * </p>
         * This is a convenience that creates an instance of the {@link ReceiptFilter.Builder} avoiding the need to
         * create one manually via {@link ReceiptFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReceiptFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(ReceiptFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ReceiptFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ReceiptFilter)
         */
        default Builder filter(Consumer<ReceiptFilter.Builder> filter) {
            return filter(ReceiptFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesRequest.BuilderImpl implements Builder {
        private ReceiptFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReceiptFilterRequest model) {
            super(model);
            filter(model.filter);
        }

        public final ReceiptFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(ReceiptFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(ReceiptFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateReceiptFilterRequest build() {
            return new CreateReceiptFilterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
