/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the verification attributes of a single identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityVerificationAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityVerificationAttributes.Builder, IdentityVerificationAttributes> {
    private static final SdkField<String> VERIFICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityVerificationAttributes::verificationStatusAsString))
            .setter(setter(Builder::verificationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationStatus").build())
            .build();

    private static final SdkField<String> VERIFICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IdentityVerificationAttributes::verificationToken)).setter(setter(Builder::verificationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFICATION_STATUS_FIELD,
            VERIFICATION_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String verificationStatus;

    private final String verificationToken;

    private IdentityVerificationAttributes(BuilderImpl builder) {
        this.verificationStatus = builder.verificationStatus;
        this.verificationToken = builder.verificationToken;
    }

    /**
     * <p>
     * The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
     * @see VerificationStatus
     */
    public VerificationStatus verificationStatus() {
        return VerificationStatus.fromValue(verificationStatus);
    }

    /**
     * <p>
     * The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #verificationStatus} will return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #verificationStatusAsString}.
     * </p>
     * 
     * @return The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
     * @see VerificationStatus
     */
    public String verificationStatusAsString() {
        return verificationStatus;
    }

    /**
     * <p>
     * The verification token for a domain identity. Null for email address identities.
     * </p>
     * 
     * @return The verification token for a domain identity. Null for email address identities.
     */
    public String verificationToken() {
        return verificationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(verificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(verificationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityVerificationAttributes)) {
            return false;
        }
        IdentityVerificationAttributes other = (IdentityVerificationAttributes) obj;
        return Objects.equals(verificationStatusAsString(), other.verificationStatusAsString())
                && Objects.equals(verificationToken(), other.verificationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IdentityVerificationAttributes").add("VerificationStatus", verificationStatusAsString())
                .add("VerificationToken", verificationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerificationStatus":
            return Optional.ofNullable(clazz.cast(verificationStatusAsString()));
        case "VerificationToken":
            return Optional.ofNullable(clazz.cast(verificationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityVerificationAttributes, T> g) {
        return obj -> g.apply((IdentityVerificationAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityVerificationAttributes> {
        /**
         * <p>
         * The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
         * </p>
         * 
         * @param verificationStatus
         *        The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(String verificationStatus);

        /**
         * <p>
         * The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
         * </p>
         * 
         * @param verificationStatus
         *        The verification status of the identity: "Pending", "Success", "Failed", or "TemporaryFailure".
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder verificationStatus(VerificationStatus verificationStatus);

        /**
         * <p>
         * The verification token for a domain identity. Null for email address identities.
         * </p>
         * 
         * @param verificationToken
         *        The verification token for a domain identity. Null for email address identities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verificationToken(String verificationToken);
    }

    static final class BuilderImpl implements Builder {
        private String verificationStatus;

        private String verificationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityVerificationAttributes model) {
            verificationStatus(model.verificationStatus);
            verificationToken(model.verificationToken);
        }

        public final String getVerificationStatusAsString() {
            return verificationStatus;
        }

        @Override
        public final Builder verificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
            return this;
        }

        @Override
        public final Builder verificationStatus(VerificationStatus verificationStatus) {
            this.verificationStatus(verificationStatus.toString());
            return this;
        }

        public final void setVerificationStatus(String verificationStatus) {
            this.verificationStatus = verificationStatus;
        }

        public final String getVerificationToken() {
            return verificationToken;
        }

        @Override
        public final Builder verificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        public final void setVerificationToken(String verificationToken) {
            this.verificationToken = verificationToken;
        }

        @Override
        public IdentityVerificationAttributes build() {
            return new IdentityVerificationAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
