/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.CreateConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.CreateDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolResponse;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.DeleteEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.GetAccountRequest;
import software.amazon.awssdk.services.sesv2.model.GetAccountResponse;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsRequest;
import software.amazon.awssdk.services.sesv2.model.GetBlacklistReportsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetEventDestinationsResponse;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetRequest;
import software.amazon.awssdk.services.sesv2.model.GetConfigurationSetResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpResponse;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityDashboardOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDeliverabilityTestReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignResponse;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportRequest;
import software.amazon.awssdk.services.sesv2.model.GetDomainStatisticsReportResponse;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityRequest;
import software.amazon.awssdk.services.sesv2.model.GetEmailIdentityResponse;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest;
import software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest;
import software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest;
import software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutAccountSendingAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetDeliveryOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetReputationOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest;
import software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpInPoolResponse;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutDedicatedIpWarmupAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionRequest;
import software.amazon.awssdk.services.sesv2.model.PutDeliverabilityDashboardOptionResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityFeedbackAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesRequest;
import software.amazon.awssdk.services.sesv2.model.PutEmailIdentityMailFromAttributesResponse;
import software.amazon.awssdk.services.sesv2.model.SendEmailRequest;
import software.amazon.awssdk.services.sesv2.model.SendEmailResponse;
import software.amazon.awssdk.services.sesv2.model.TagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.TagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.sesv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationRequest;
import software.amazon.awssdk.services.sesv2.model.UpdateConfigurationSetEventDestinationResponse;
import software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher;
import software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher;

/**
 * Service client for accessing Amazon SES V2 asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Amazon SES API v2</fullname>
 * <p>
 * Welcome to the Amazon SES API v2 Reference. This guide provides information about the Amazon SES API v2, including
 * supported operations, data types, parameters, and schemas.
 * </p>
 * <p>
 * <a href="https://aws.amazon.com/pinpoint">Amazon SES</a> is an AWS service that you can use to send email messages to
 * your customers.
 * </p>
 * <p>
 * If you're new to Amazon SES API v2, you might find it helpful to also review the <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/">Amazon Simple Email Service Developer Guide</a>. The
 * <i>Amazon SES Developer Guide</i> provides information and code samples that demonstrate how to use Amazon SES API v2
 * features programmatically.
 * </p>
 * <p>
 * The Amazon SES API v2 is available in several AWS Regions and it provides an endpoint for each of these Regions. For
 * a list of all the Regions and endpoints where the API is currently available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#ses_region">AWS Service Endpoints</a> in the <i>Amazon
 * Web Services General Reference</i>. To learn more about AWS Regions, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing AWS Regions</a> in the <i>Amazon Web
 * Services General Reference</i>.
 * </p>
 * <p>
 * In each Region, AWS maintains multiple Availability Zones. These Availability Zones are physically isolated from each
 * other, but are united by private, low-latency, high-throughput, and highly redundant network connections. These
 * Availability Zones enable us to provide very high levels of availability and redundancy, while also minimizing
 * latency. To learn more about the number of Availability Zones that are available in each Region, see <a
 * href="http://aws.amazon.com/about-aws/global-infrastructure/">AWS Global Infrastructure</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SesV2AsyncClient extends SdkClient {
    String SERVICE_NAME = "ses";

    /**
     * Create a {@link SesV2AsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SesV2AsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SesV2AsyncClient}.
     */
    static SesV2AsyncClientBuilder builder() {
        return new DefaultSesV2AsyncClientBuilder();
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A request to create a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            CreateConfigurationSetRequest createConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a configuration set. <i>Configuration sets</i> are groups of rules that you can apply to the emails that
     * you send. You apply a configuration set to an email by specifying the name of the configuration set when you call
     * the Amazon SES API v2. When you apply a configuration set to an email, all of the rules in that configuration set
     * are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateConfigurationSetRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetRequest.Builder} to create a
     *        request. A request to create a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetResponse> createConfigurationSet(
            Consumer<CreateConfigurationSetRequest.Builder> createConfigurationSetRequest) {
        return createConfigurationSet(CreateConfigurationSetRequest.builder().applyMutation(createConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints,
     * or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A request to add an event destination to a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create an event destination. <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and
     * complaints. <i>Event destinations</i> are places that you can send information about these events to. For
     * example, you can send event data to Amazon SNS to receive notifications when you receive bounces or complaints,
     * or you can use Amazon Kinesis Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <p>
     * A single configuration set can include more than one event destination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param createConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link CreateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to add an event destination to a configuration set.
     * @return A Java Future containing the result of the CreateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateConfigurationSetEventDestinationResponse> createConfigurationSetEventDestination(
            Consumer<CreateConfigurationSetEventDestinationRequest.Builder> createConfigurationSetEventDestinationRequest) {
        return createConfigurationSetEventDestination(CreateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(createConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your AWS account. You can associate a pool with a configuration set. When you send an email that
     * uses that configuration set, the message is sent from one of the addresses in the associated pool.
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A request to create a new dedicated IP pool.
     * @return A Java Future containing the result of the CreateDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDedicatedIpPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(
            CreateDedicatedIpPoolRequest createDedicatedIpPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new pool of dedicated IP addresses. A pool can include one or more dedicated IP addresses that are
     * associated with your AWS account. You can associate a pool with a configuration set. When you send an email that
     * uses that configuration set, the message is sent from one of the addresses in the associated pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param createDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on {@link CreateDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to create a new dedicated IP pool.
     * @return A Java Future containing the result of the CreateDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDedicatedIpPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateDedicatedIpPoolResponse> createDedicatedIpPool(
            Consumer<CreateDedicatedIpPoolRequest.Builder> createDedicatedIpPoolRequest) {
        return createDedicatedIpPool(CreateDedicatedIpPoolRequest.builder().applyMutation(createDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES API v2 then sends that message to special email addresses spread across several major email providers.
     * After about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results of the test.
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A request to perform a predictive inbox placement test. Predictive inbox placement tests can help you
     *        predict how your messages will be handled by various email providers around the world. When you perform a
     *        predictive inbox placement test, you provide a sample message that contains the content that you plan to
     *        send to your customers. We send that message to special email addresses spread across several major email
     *        providers around the world. The test takes about 24 hours to complete. When the test is complete, you can
     *        use the <code>GetDeliverabilityTestReport</code> operation to view the results of the test.
     * @return A Java Future containing the result of the CreateDeliverabilityTestReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDeliverabilityTestReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(
            CreateDeliverabilityTestReportRequest createDeliverabilityTestReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a new predictive inbox placement test. Predictive inbox placement tests can help you predict how your
     * messages will be handled by various email providers around the world. When you perform a predictive inbox
     * placement test, you provide a sample message that contains the content that you plan to send to your customers.
     * Amazon SES API v2 then sends that message to special email addresses spread across several major email providers.
     * After about 24 hours, the test is complete, and you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results of the test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param createDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeliverabilityTestReportRequest.Builder} to
     *        create a request. A request to perform a predictive inbox placement test. Predictive inbox placement tests
     *        can help you predict how your messages will be handled by various email providers around the world. When
     *        you perform a predictive inbox placement test, you provide a sample message that contains the content that
     *        you plan to send to your customers. We send that message to special email addresses spread across several
     *        major email providers around the world. The test takes about 24 hours to complete. When the test is
     *        complete, you can use the <code>GetDeliverabilityTestReport</code> operation to view the results of the
     *        test.
     * @return A Java Future containing the result of the CreateDeliverabilityTestReport operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateDeliverabilityTestReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDeliverabilityTestReportResponse> createDeliverabilityTestReport(
            Consumer<CreateDeliverabilityTestReportRequest.Builder> createDeliverabilityTestReportRequest) {
        return createDeliverabilityTestReport(CreateDeliverabilityTestReportRequest.builder()
                .applyMutation(createDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A request to begin the verification process for an email identity (an email address or domain).
     * @return A Java Future containing the result of the CreateEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(
            CreateEmailIdentityRequest createEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the process of verifying an email identity. An <i>identity</i> is an email address or domain that you use
     * when you send email. Before you can use an identity to send email, you first have to verify it. By verifying an
     * identity, you demonstrate that you're the owner of the identity, and that you've given Amazon SES API v2
     * permission to send email from the identity.
     * </p>
     * <p>
     * When you verify an email address, Amazon SES sends an email to the address. Your email address is verified as
     * soon as you follow the link in the verification email.
     * </p>
     * <p>
     * When you verify a domain, this operation provides a set of DKIM tokens, which you can convert into CNAME tokens.
     * You add these CNAME tokens to the DNS configuration for your domain. Your domain is verified when Amazon SES
     * detects these records in the DNS configuration for your domain. For some DNS providers, it can take 72 hours or
     * more to complete the domain verification process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEmailIdentityRequest#builder()}
     * </p>
     *
     * @param createEmailIdentityRequest
     *        A {@link Consumer} that will call methods on {@link CreateEmailIdentityRequest.Builder} to create a
     *        request. A request to begin the verification process for an email identity (an email address or domain).
     * @return A Java Future containing the result of the CreateEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.CreateEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/CreateEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEmailIdentityResponse> createEmailIdentity(
            Consumer<CreateEmailIdentityRequest.Builder> createEmailIdentityRequest) {
        return createEmailIdentity(CreateEmailIdentityRequest.builder().applyMutation(createEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A request to delete a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            DeleteConfigurationSetRequest deleteConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an existing configuration set.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteConfigurationSetRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetRequest.Builder} to create a
     *        request. A request to delete a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSet" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetResponse> deleteConfigurationSet(
            Consumer<DeleteConfigurationSetRequest.Builder> deleteConfigurationSetRequest) {
        return deleteConfigurationSet(DeleteConfigurationSetRequest.builder().applyMutation(deleteConfigurationSetRequest)
                .build());
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A request to delete an event destination from a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            DeleteConfigurationSetEventDestinationRequest deleteConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an event destination.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to delete an event destination from a configuration set.
     * @return A Java Future containing the result of the DeleteConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteConfigurationSetEventDestinationResponse> deleteConfigurationSetEventDestination(
            Consumer<DeleteConfigurationSetEventDestinationRequest.Builder> deleteConfigurationSetEventDestinationRequest) {
        return deleteConfigurationSetEventDestination(DeleteConfigurationSetEventDestinationRequest.builder()
                .applyMutation(deleteConfigurationSetEventDestinationRequest).build());
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A request to delete a dedicated IP pool.
     * @return A Java Future containing the result of the DeleteDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteDedicatedIpPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(
            DeleteDedicatedIpPoolRequest deleteDedicatedIpPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a dedicated IP pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDedicatedIpPoolRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDedicatedIpPoolRequest#builder()}
     * </p>
     *
     * @param deleteDedicatedIpPoolRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDedicatedIpPoolRequest.Builder} to create a
     *        request. A request to delete a dedicated IP pool.
     * @return A Java Future containing the result of the DeleteDedicatedIpPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteDedicatedIpPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteDedicatedIpPool" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDedicatedIpPoolResponse> deleteDedicatedIpPool(
            Consumer<DeleteDedicatedIpPoolRequest.Builder> deleteDedicatedIpPoolRequest) {
        return deleteDedicatedIpPool(DeleteDedicatedIpPoolRequest.builder().applyMutation(deleteDedicatedIpPoolRequest).build());
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A request to delete an existing email identity. When you delete an identity, you lose the ability to send
     *        email from that identity. You can restore your ability to send email by completing the verification
     *        process for the identity again.
     * @return A Java Future containing the result of the DeleteEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(
            DeleteEmailIdentityRequest deleteEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an email identity. An identity can be either an email address or a domain name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEmailIdentityRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEmailIdentityRequest#builder()}
     * </p>
     *
     * @param deleteEmailIdentityRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEmailIdentityRequest.Builder} to create a
     *        request. A request to delete an existing email identity. When you delete an identity, you lose the ability
     *        to send email from that identity. You can restore your ability to send email by completing the
     *        verification process for the identity again.
     * @return A Java Future containing the result of the DeleteEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.DeleteEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/DeleteEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEmailIdentityResponse> deleteEmailIdentity(
            Consumer<DeleteEmailIdentityRequest.Builder> deleteEmailIdentityRequest) {
        return deleteEmailIdentity(DeleteEmailIdentityRequest.builder().applyMutation(deleteEmailIdentityRequest).build());
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current AWS
     * Region.
     * </p>
     *
     * @param getAccountRequest
     *        A request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(GetAccountRequest getAccountRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Obtain information about the email-sending status and capabilities of your Amazon SES account in the current AWS
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccountRequest#builder()}
     * </p>
     *
     * @param getAccountRequest
     *        A {@link Consumer} that will call methods on {@link GetAccountRequest.Builder} to create a request. A
     *        request to obtain information about the email-sending capabilities of your Amazon SES account.
     * @return A Java Future containing the result of the GetAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetAccount
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetAccount" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAccountResponse> getAccount(Consumer<GetAccountRequest.Builder> getAccountRequest) {
        return getAccount(GetAccountRequest.builder().applyMutation(getAccountRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return A Java Future containing the result of the GetBlacklistReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetBlacklistReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(
            GetBlacklistReportsRequest getBlacklistReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBlacklistReportsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBlacklistReportsRequest#builder()}
     * </p>
     *
     * @param getBlacklistReportsRequest
     *        A {@link Consumer} that will call methods on {@link GetBlacklistReportsRequest.Builder} to create a
     *        request. A request to retrieve a list of the blacklists that your dedicated IP addresses appear on.
     * @return A Java Future containing the result of the GetBlacklistReports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetBlacklistReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetBlacklistReports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBlacklistReportsResponse> getBlacklistReports(
            Consumer<GetBlacklistReportsRequest.Builder> getBlacklistReportsRequest) {
        return getBlacklistReports(GetBlacklistReportsRequest.builder().applyMutation(getBlacklistReportsRequest).build());
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A request to obtain information about a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(
            GetConfigurationSetRequest getConfigurationSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an existing configuration set, including the dedicated IP pool that it's associated with,
     * whether or not it's enabled for sending email, and more.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationSetRequest.Builder} avoiding the
     * need to create one manually via {@link GetConfigurationSetRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigurationSetRequest.Builder} to create a
     *        request. A request to obtain information about a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetResponse> getConfigurationSet(
            Consumer<GetConfigurationSetRequest.Builder> getConfigurationSetRequest) {
        return getConfigurationSet(GetConfigurationSetRequest.builder().applyMutation(getConfigurationSetRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A request to obtain information about the event destinations for a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSetEventDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSetEventDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(
            GetConfigurationSetEventDestinationsRequest getConfigurationSetEventDestinationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of event destinations that are associated with a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetConfigurationSetEventDestinationsRequest.Builder} avoiding the need to create one manually via
     * {@link GetConfigurationSetEventDestinationsRequest#builder()}
     * </p>
     *
     * @param getConfigurationSetEventDestinationsRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigurationSetEventDestinationsRequest.Builder}
     *        to create a request. A request to obtain information about the event destinations for a configuration set.
     * @return A Java Future containing the result of the GetConfigurationSetEventDestinations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetConfigurationSetEventDestinations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetConfigurationSetEventDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetConfigurationSetEventDestinationsResponse> getConfigurationSetEventDestinations(
            Consumer<GetConfigurationSetEventDestinationsRequest.Builder> getConfigurationSetEventDestinationsRequest) {
        return getConfigurationSetEventDestinations(GetConfigurationSetEventDestinationsRequest.builder()
                .applyMutation(getConfigurationSetEventDestinationsRequest).build());
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A request to obtain more information about a dedicated IP address.
     * @return A Java Future containing the result of the GetDedicatedIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(GetDedicatedIpRequest getDedicatedIpRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a dedicated IP address, including the name of the dedicated IP pool that it's associated
     * with, as well information about the automatic warm-up process for the address.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpRequest.Builder} avoiding the need to
     * create one manually via {@link GetDedicatedIpRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpRequest
     *        A {@link Consumer} that will call methods on {@link GetDedicatedIpRequest.Builder} to create a request. A
     *        request to obtain more information about a dedicated IP address.
     * @return A Java Future containing the result of the GetDedicatedIp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIp
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpResponse> getDedicatedIp(Consumer<GetDedicatedIpRequest.Builder> getDedicatedIpRequest) {
        return getDedicatedIp(GetDedicatedIpRequest.builder().applyMutation(getDedicatedIpRequest).build());
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your AWS account.
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A Java Future containing the result of the GetDedicatedIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on {@link GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return A Java Future containing the result of the GetDedicatedIps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDedicatedIpsResponse> getDedicatedIps(
            Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest) {
        return getDedicatedIps(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A request to obtain more information about dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsPublisher getDedicatedIpsPaginator(GetDedicatedIpsRequest getDedicatedIpsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the dedicated IP addresses that are associated with your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.GetDedicatedIpsPublisher publisher = client.getDedicatedIpsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDedicatedIps(software.amazon.awssdk.services.sesv2.model.GetDedicatedIpsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDedicatedIpsRequest.Builder} avoiding the need
     * to create one manually via {@link GetDedicatedIpsRequest#builder()}
     * </p>
     *
     * @param getDedicatedIpsRequest
     *        A {@link Consumer} that will call methods on {@link GetDedicatedIpsRequest.Builder} to create a request. A
     *        request to obtain more information about dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDedicatedIps
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDedicatedIps" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDedicatedIpsPublisher getDedicatedIpsPaginator(Consumer<GetDedicatedIpsRequest.Builder> getDedicatedIpsRequest) {
        return getDedicatedIpsPaginator(GetDedicatedIpsRequest.builder().applyMutation(getDedicatedIpsRequest).build());
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a
     * Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint
     * Pricing</a>.
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        Retrieve information about the status of the Deliverability dashboard for your AWS account. When the
     *        Deliverability dashboard is enabled, you gain access to reputation, deliverability, and other metrics for
     *        your domains. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other AWS services. For more information about the features
     *        and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the GetDeliverabilityDashboardOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         BadRequestException The input you provided is invalid.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>SesV2Exception Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityDashboardOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(
            GetDeliverabilityDashboardOptionsRequest getDeliverabilityDashboardOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about the status of the Deliverability dashboard for your account. When the Deliverability
     * dashboard is enabled, you gain access to reputation, deliverability, and other metrics for the domains that you
     * use to send email. You also gain the ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a
     * Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint
     * Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityDashboardOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityDashboardOptionsRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityDashboardOptionsRequest
     *        A {@link Consumer} that will call methods on {@link GetDeliverabilityDashboardOptionsRequest.Builder} to
     *        create a request. Retrieve information about the status of the Deliverability dashboard for your AWS
     *        account. When the Deliverability dashboard is enabled, you gain access to reputation, deliverability, and
     *        other metrics for your domains. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other AWS services. For more information about the features
     *        and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the GetDeliverabilityDashboardOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li> <li>
     *         LimitExceededException There are too many instances of the specified resource type.</li> <li>
     *         BadRequestException The input you provided is invalid.</li> <li>SdkException Base class for all
     *         exceptions that can be thrown by the SDK (both service and client). Can be used for catch all scenarios.
     *         </li> <li>SdkClientException If any client side error occurs such as an IO related failure, failure to
     *         get credentials, etc.</li> <li>SesV2Exception Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityDashboardOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityDashboardOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityDashboardOptionsResponse> getDeliverabilityDashboardOptions(
            Consumer<GetDeliverabilityDashboardOptionsRequest.Builder> getDeliverabilityDashboardOptionsRequest) {
        return getDeliverabilityDashboardOptions(GetDeliverabilityDashboardOptionsRequest.builder()
                .applyMutation(getDeliverabilityDashboardOptionsRequest).build());
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A request to retrieve the results of a predictive inbox placement test.
     * @return A Java Future containing the result of the GetDeliverabilityTestReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityTestReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(
            GetDeliverabilityTestReportRequest getDeliverabilityTestReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve the results of a predictive inbox placement test.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeliverabilityTestReportRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeliverabilityTestReportRequest#builder()}
     * </p>
     *
     * @param getDeliverabilityTestReportRequest
     *        A {@link Consumer} that will call methods on {@link GetDeliverabilityTestReportRequest.Builder} to create
     *        a request. A request to retrieve the results of a predictive inbox placement test.
     * @return A Java Future containing the result of the GetDeliverabilityTestReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDeliverabilityTestReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDeliverabilityTestReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeliverabilityTestReportResponse> getDeliverabilityTestReport(
            Consumer<GetDeliverabilityTestReportRequest.Builder> getDeliverabilityTestReportRequest) {
        return getDeliverabilityTestReport(GetDeliverabilityTestReportRequest.builder()
                .applyMutation(getDeliverabilityTestReportRequest).build());
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only
     *        if the campaign sent email by using a domain that the Deliverability dashboard is enabled for (
     *        <code>PutDeliverabilityDashboardOption</code> operation).
     * @return A Java Future containing the result of the GetDomainDeliverabilityCampaign operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainDeliverabilityCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(
            GetDomainDeliverabilityCampaignRequest getDomainDeliverabilityCampaignRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve all the deliverability data for a specific campaign. This data is available for a campaign only if the
     * campaign sent email by using a domain that the Deliverability dashboard is enabled for.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainDeliverabilityCampaignRequest.Builder}
     * avoiding the need to create one manually via {@link GetDomainDeliverabilityCampaignRequest#builder()}
     * </p>
     *
     * @param getDomainDeliverabilityCampaignRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainDeliverabilityCampaignRequest.Builder} to
     *        create a request. Retrieve all the deliverability data for a specific campaign. This data is available for
     *        a campaign only if the campaign sent email by using a domain that the Deliverability dashboard is enabled
     *        for (<code>PutDeliverabilityDashboardOption</code> operation).
     * @return A Java Future containing the result of the GetDomainDeliverabilityCampaign operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainDeliverabilityCampaign
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainDeliverabilityCampaign"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainDeliverabilityCampaignResponse> getDomainDeliverabilityCampaign(
            Consumer<GetDomainDeliverabilityCampaignRequest.Builder> getDomainDeliverabilityCampaignRequest) {
        return getDomainDeliverabilityCampaign(GetDomainDeliverabilityCampaignRequest.builder()
                .applyMutation(getDomainDeliverabilityCampaignRequest).build());
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A request to obtain deliverability metrics for a domain.
     * @return A Java Future containing the result of the GetDomainStatisticsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainStatisticsReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(
            GetDomainStatisticsReportRequest getDomainStatisticsReportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve inbox placement and engagement rates for the domains that you use to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainStatisticsReportRequest.Builder} avoiding
     * the need to create one manually via {@link GetDomainStatisticsReportRequest#builder()}
     * </p>
     *
     * @param getDomainStatisticsReportRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainStatisticsReportRequest.Builder} to create a
     *        request. A request to obtain deliverability metrics for a domain.
     * @return A Java Future containing the result of the GetDomainStatisticsReport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetDomainStatisticsReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetDomainStatisticsReport"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDomainStatisticsReportResponse> getDomainStatisticsReport(
            Consumer<GetDomainStatisticsReportRequest.Builder> getDomainStatisticsReportRequest) {
        return getDomainStatisticsReport(GetDomainStatisticsReportRequest.builder()
                .applyMutation(getDomainStatisticsReportRequest).build());
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, its DKIM
     * authentication status, and its custom Mail-From settings.
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A request to return details about an email identity.
     * @return A Java Future containing the result of the GetEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(GetEmailIdentityRequest getEmailIdentityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a specific identity, including the identity's verification status, its DKIM
     * authentication status, and its custom Mail-From settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEmailIdentityRequest.Builder} avoiding the need
     * to create one manually via {@link GetEmailIdentityRequest#builder()}
     * </p>
     *
     * @param getEmailIdentityRequest
     *        A {@link Consumer} that will call methods on {@link GetEmailIdentityRequest.Builder} to create a request.
     *        A request to return details about an email identity.
     * @return A Java Future containing the result of the GetEmailIdentity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.GetEmailIdentity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/GetEmailIdentity" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEmailIdentityResponse> getEmailIdentity(
            Consumer<GetEmailIdentityRequest.Builder> getEmailIdentityRequest) {
        return getEmailIdentity(GetEmailIdentityRequest.builder().applyMutation(getEmailIdentityRequest).build());
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current AWS Region.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current AWS
     *        Region.
     * @return A Java Future containing the result of the ListConfigurationSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListConfigurationSetsResponse> listConfigurationSets(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) {
        return listConfigurationSets(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest).build());
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A request to obtain a list of configuration sets for your Amazon SES account in the current AWS Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsPublisher listConfigurationSetsPaginator(
            ListConfigurationSetsRequest listConfigurationSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the configuration sets associated with your account in the current region.
     * </p>
     * <p>
     * <i>Configuration sets</i> are groups of rules that you can apply to the emails you send. You apply a
     * configuration set to an email by including a reference to the configuration set in the headers of the email. When
     * you apply a configuration set to an email, all of the rules in that configuration set are applied to the email.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListConfigurationSetsPublisher publisher = client.listConfigurationSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationSets(software.amazon.awssdk.services.sesv2.model.ListConfigurationSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListConfigurationSetsRequest#builder()}
     * </p>
     *
     * @param listConfigurationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListConfigurationSetsRequest.Builder} to create a
     *        request. A request to obtain a list of configuration sets for your Amazon SES account in the current AWS
     *        Region.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListConfigurationSets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListConfigurationSets" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConfigurationSetsPublisher listConfigurationSetsPaginator(
            Consumer<ListConfigurationSetsRequest.Builder> listConfigurationSetsRequest) {
        return listConfigurationSetsPaginator(ListConfigurationSetsRequest.builder().applyMutation(listConfigurationSetsRequest)
                .build());
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your AWS account in the current Region.
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A Java Future containing the result of the ListDedicatedIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(
            ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your AWS account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return A Java Future containing the result of the ListDedicatedIpPools operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDedicatedIpPoolsResponse> listDedicatedIpPools(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) {
        return listDedicatedIpPools(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest).build());
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your AWS account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A request to obtain a list of dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDedicatedIpPoolsPublisher listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest listDedicatedIpPoolsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all of the dedicated IP pools that exist in your AWS account in the current Region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDedicatedIpPoolsPublisher publisher = client.listDedicatedIpPoolsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDedicatedIpPools(software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDedicatedIpPoolsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDedicatedIpPoolsRequest#builder()}
     * </p>
     *
     * @param listDedicatedIpPoolsRequest
     *        A {@link Consumer} that will call methods on {@link ListDedicatedIpPoolsRequest.Builder} to create a
     *        request. A request to obtain a list of dedicated IP pools.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDedicatedIpPools
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDedicatedIpPools" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDedicatedIpPoolsPublisher listDedicatedIpPoolsPaginator(
            Consumer<ListDedicatedIpPoolsRequest.Builder> listDedicatedIpPoolsRequest) {
        return listDedicatedIpPoolsPaginator(ListDedicatedIpPoolsRequest.builder().applyMutation(listDedicatedIpPoolsRequest)
                .build());
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A Java Future containing the result of the ListDeliverabilityTestReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeliverabilityTestReportsRequest.Builder} to
     *        create a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return A Java Future containing the result of the ListDeliverabilityTestReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDeliverabilityTestReportsResponse> listDeliverabilityTestReports(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest) {
        return listDeliverabilityTestReports(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsPublisher listDeliverabilityTestReportsPaginator(
            ListDeliverabilityTestReportsRequest listDeliverabilityTestReportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Show a list of the predictive inbox placement tests that you've performed, regardless of their statuses. For
     * predictive inbox placement tests that are complete, you can use the <code>GetDeliverabilityTestReport</code>
     * operation to view the results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDeliverabilityTestReportsPublisher publisher = client.listDeliverabilityTestReportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeliverabilityTestReports(software.amazon.awssdk.services.sesv2.model.ListDeliverabilityTestReportsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeliverabilityTestReportsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDeliverabilityTestReportsRequest#builder()}
     * </p>
     *
     * @param listDeliverabilityTestReportsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeliverabilityTestReportsRequest.Builder} to
     *        create a request. A request to list all of the predictive inbox placement tests that you've performed.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDeliverabilityTestReports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDeliverabilityTestReports"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDeliverabilityTestReportsPublisher listDeliverabilityTestReportsPaginator(
            Consumer<ListDeliverabilityTestReportsRequest.Builder> listDeliverabilityTestReportsRequest) {
        return listDeliverabilityTestReportsPaginator(ListDeliverabilityTestReportsRequest.builder()
                .applyMutation(listDeliverabilityTestReportsRequest).build());
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A Java Future containing the result of the ListDomainDeliverabilityCampaigns operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return A Java Future containing the result of the ListDomainDeliverabilityCampaigns operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDomainDeliverabilityCampaignsResponse> listDomainDeliverabilityCampaigns(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest) {
        return listDomainDeliverabilityCampaigns(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        Retrieve deliverability data for all the campaigns that used a specific domain to send email during a
     *        specified time range. This data is available for a domain only if you enabled the Deliverability
     *        dashboard.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsPublisher listDomainDeliverabilityCampaignsPaginator(
            ListDomainDeliverabilityCampaignsRequest listDomainDeliverabilityCampaignsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified
     * time range. This data is available for a domain only if you enabled the Deliverability dashboard for the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListDomainDeliverabilityCampaignsPublisher publisher = client.listDomainDeliverabilityCampaignsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainDeliverabilityCampaigns(software.amazon.awssdk.services.sesv2.model.ListDomainDeliverabilityCampaignsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainDeliverabilityCampaignsRequest.Builder}
     * avoiding the need to create one manually via {@link ListDomainDeliverabilityCampaignsRequest#builder()}
     * </p>
     *
     * @param listDomainDeliverabilityCampaignsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainDeliverabilityCampaignsRequest.Builder} to
     *        create a request. Retrieve deliverability data for all the campaigns that used a specific domain to send
     *        email during a specified time range. This data is available for a domain only if you enabled the
     *        Deliverability dashboard.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListDomainDeliverabilityCampaigns
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListDomainDeliverabilityCampaigns"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDomainDeliverabilityCampaignsPublisher listDomainDeliverabilityCampaignsPaginator(
            Consumer<ListDomainDeliverabilityCampaignsRequest.Builder> listDomainDeliverabilityCampaignsRequest) {
        return listDomainDeliverabilityCampaignsPaginator(ListDomainDeliverabilityCampaignsRequest.builder()
                .applyMutation(listDomainDeliverabilityCampaignsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your AWS account. An identity can be
     * either an email address or a domain. This operation returns identities that are verified as well as those that
     * aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your AWS account. This list includes
     *        identities that you've already verified, identities that are unverified, and identities that were verified
     *        in the past, but are no longer verified.
     * @return A Java Future containing the result of the ListEmailIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(
            ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your AWS account. An identity can be
     * either an email address or a domain. This operation returns identities that are verified as well as those that
     * aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your AWS account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A Java Future containing the result of the ListEmailIdentities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListEmailIdentitiesResponse> listEmailIdentities(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) {
        return listEmailIdentities(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your AWS account. An identity can be
     * either an email address or a domain. This operation returns identities that are verified as well as those that
     * aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A request to list all of the email identities associated with your AWS account. This list includes
     *        identities that you've already verified, identities that are unverified, and identities that were verified
     *        in the past, but are no longer verified.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesPublisher listEmailIdentitiesPaginator(ListEmailIdentitiesRequest listEmailIdentitiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all of the email identities that are associated with your AWS account. An identity can be
     * either an email address or a domain. This operation returns identities that are verified as well as those that
     * aren't. This operation returns identities that are associated with Amazon SES and Amazon Pinpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sesv2.paginators.ListEmailIdentitiesPublisher publisher = client.listEmailIdentitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEmailIdentities(software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEmailIdentitiesRequest.Builder} avoiding the
     * need to create one manually via {@link ListEmailIdentitiesRequest#builder()}
     * </p>
     *
     * @param listEmailIdentitiesRequest
     *        A {@link Consumer} that will call methods on {@link ListEmailIdentitiesRequest.Builder} to create a
     *        request. A request to list all of the email identities associated with your AWS account. This list
     *        includes identities that you've already verified, identities that are unverified, and identities that were
     *        verified in the past, but are no longer verified.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListEmailIdentities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListEmailIdentities" target="_top">AWS API
     *      Documentation</a>
     */
    default ListEmailIdentitiesPublisher listEmailIdentitiesPaginator(
            Consumer<ListEmailIdentitiesRequest.Builder> listEmailIdentitiesRequest) {
        return listEmailIdentitiesPaginator(ListEmailIdentitiesRequest.builder().applyMutation(listEmailIdentitiesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of the tags (keys and values) that are associated with a specified resource. A <i>tag</i> is a
     * label that you optionally define and associate with a resource. Each tag consists of a required <i>tag
     * key</i> and an optional associated <i>tag value</i>. A tag key is a general label that acts as a category for
     * more specific tag values. A tag value acts as a descriptor within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A request to enable or disable the automatic IP address warm-up feature.
     * @return A Java Future containing the result of the PutAccountDedicatedIpWarmupAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(
            PutAccountDedicatedIpWarmupAttributesRequest putAccountDedicatedIpWarmupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the automatic warm-up feature for dedicated IP addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutAccountDedicatedIpWarmupAttributesRequest.Builder} avoiding the need to create one manually via
     * {@link PutAccountDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutAccountDedicatedIpWarmupAttributesRequest.Builder}
     *        to create a request. A request to enable or disable the automatic IP address warm-up feature.
     * @return A Java Future containing the result of the PutAccountDedicatedIpWarmupAttributes operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountDedicatedIpWarmupAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountDedicatedIpWarmupAttributesResponse> putAccountDedicatedIpWarmupAttributes(
            Consumer<PutAccountDedicatedIpWarmupAttributesRequest.Builder> putAccountDedicatedIpWarmupAttributesRequest) {
        return putAccountDedicatedIpWarmupAttributes(PutAccountDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putAccountDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A request to change the ability of your account to send email.
     * @return A Java Future containing the result of the PutAccountSendingAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSendingAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(
            PutAccountSendingAttributesRequest putAccountSendingAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the ability of your account to send email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAccountSendingAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutAccountSendingAttributesRequest#builder()}
     * </p>
     *
     * @param putAccountSendingAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutAccountSendingAttributesRequest.Builder} to create
     *        a request. A request to change the ability of your account to send email.
     * @return A Java Future containing the result of the PutAccountSendingAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutAccountSendingAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutAccountSendingAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutAccountSendingAttributesResponse> putAccountSendingAttributes(
            Consumer<PutAccountSendingAttributesRequest.Builder> putAccountSendingAttributesRequest) {
        return putAccountSendingAttributes(PutAccountSendingAttributesRequest.builder()
                .applyMutation(putAccountSendingAttributesRequest).build());
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A request to associate a configuration set with a dedicated IP pool.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            PutConfigurationSetDeliveryOptionsRequest putConfigurationSetDeliveryOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate a configuration set with a dedicated IP pool. You can use dedicated IP pools to create groups of
     * dedicated IP addresses for sending specific types of email.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetDeliveryOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetDeliveryOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetDeliveryOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationSetDeliveryOptionsRequest.Builder} to
     *        create a request. A request to associate a configuration set with a dedicated IP pool.
     * @return A Java Future containing the result of the PutConfigurationSetDeliveryOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetDeliveryOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetDeliveryOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetDeliveryOptionsResponse> putConfigurationSetDeliveryOptions(
            Consumer<PutConfigurationSetDeliveryOptionsRequest.Builder> putConfigurationSetDeliveryOptionsRequest) {
        return putConfigurationSetDeliveryOptions(PutConfigurationSetDeliveryOptionsRequest.builder()
                .applyMutation(putConfigurationSetDeliveryOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific AWS Region.
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A request to enable or disable tracking of reputation metrics for a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetReputationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetReputationOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(
            PutConfigurationSetReputationOptionsRequest putConfigurationSetReputationOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable collection of reputation metrics for emails that you send using a particular configuration set
     * in a specific AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutConfigurationSetReputationOptionsRequest.Builder} avoiding the need to create one manually via
     * {@link PutConfigurationSetReputationOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetReputationOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationSetReputationOptionsRequest.Builder}
     *        to create a request. A request to enable or disable tracking of reputation metrics for a configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetReputationOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetReputationOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetReputationOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetReputationOptionsResponse> putConfigurationSetReputationOptions(
            Consumer<PutConfigurationSetReputationOptionsRequest.Builder> putConfigurationSetReputationOptionsRequest) {
        return putConfigurationSetReputationOptions(PutConfigurationSetReputationOptionsRequest.builder()
                .applyMutation(putConfigurationSetReputationOptionsRequest).build());
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A request to enable or disable the ability of Amazon SES to send emails that use a specific configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetSendingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSendingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(
            PutConfigurationSetSendingOptionsRequest putConfigurationSetSendingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable email sending for messages that use a particular configuration set in a specific AWS Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetSendingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetSendingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetSendingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationSetSendingOptionsRequest.Builder} to
     *        create a request. A request to enable or disable the ability of Amazon SES to send emails that use a
     *        specific configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetSendingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetSendingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetSendingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetSendingOptionsResponse> putConfigurationSetSendingOptions(
            Consumer<PutConfigurationSetSendingOptionsRequest.Builder> putConfigurationSetSendingOptionsRequest) {
        return putConfigurationSetSendingOptions(PutConfigurationSetSendingOptionsRequest.builder()
                .applyMutation(putConfigurationSetSendingOptionsRequest).build());
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A request to add a custom domain for tracking open and click events to a configuration set.
     * @return A Java Future containing the result of the PutConfigurationSetTrackingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(
            PutConfigurationSetTrackingOptionsRequest putConfigurationSetTrackingOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specify a custom domain to use for open and click tracking elements in email that you send.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationSetTrackingOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link PutConfigurationSetTrackingOptionsRequest#builder()}
     * </p>
     *
     * @param putConfigurationSetTrackingOptionsRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationSetTrackingOptionsRequest.Builder} to
     *        create a request. A request to add a custom domain for tracking open and click events to a configuration
     *        set.
     * @return A Java Future containing the result of the PutConfigurationSetTrackingOptions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutConfigurationSetTrackingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutConfigurationSetTrackingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutConfigurationSetTrackingOptionsResponse> putConfigurationSetTrackingOptions(
            Consumer<PutConfigurationSetTrackingOptionsRequest.Builder> putConfigurationSetTrackingOptionsRequest) {
        return putConfigurationSetTrackingOptions(PutConfigurationSetTrackingOptionsRequest.builder()
                .applyMutation(putConfigurationSetTrackingOptionsRequest).build());
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your AWS account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note>
     *
     * @param putDedicatedIpInPoolRequest
     *        A request to move a dedicated IP address to a dedicated IP pool.
     * @return A Java Future containing the result of the PutDedicatedIpInPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpInPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(
            PutDedicatedIpInPoolRequest putDedicatedIpInPoolRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Move a dedicated IP address to an existing dedicated IP pool.
     * </p>
     * <note>
     * <p>
     * The dedicated IP address that you specify must already exist, and must be associated with your AWS account.
     * </p>
     * <p>
     * The dedicated IP pool you specify must already exist. You can create a new pool by using the
     * <code>CreateDedicatedIpPool</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpInPoolRequest.Builder} avoiding the
     * need to create one manually via {@link PutDedicatedIpInPoolRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpInPoolRequest
     *        A {@link Consumer} that will call methods on {@link PutDedicatedIpInPoolRequest.Builder} to create a
     *        request. A request to move a dedicated IP address to a dedicated IP pool.
     * @return A Java Future containing the result of the PutDedicatedIpInPool operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpInPool
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpInPool" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpInPoolResponse> putDedicatedIpInPool(
            Consumer<PutDedicatedIpInPoolRequest.Builder> putDedicatedIpInPoolRequest) {
        return putDedicatedIpInPool(PutDedicatedIpInPoolRequest.builder().applyMutation(putDedicatedIpInPoolRequest).build());
    }

    /**
     * <p/>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A request to change the warm-up attributes for a dedicated IP address. This operation is useful when you
     *        want to resume the warm-up process for an existing IP address.
     * @return A Java Future containing the result of the PutDedicatedIpWarmupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li> <li>
     *         TooManyRequestsException Too many requests have been made to the operation.</li> <li>BadRequestException
     *         The input you provided is invalid.</li> <li>SdkException Base class for all exceptions that can be thrown
     *         by the SDK (both service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If
     *         any client side error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>
     *         SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an instance of
     *         this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpWarmupAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(
            PutDedicatedIpWarmupAttributesRequest putDedicatedIpWarmupAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDedicatedIpWarmupAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutDedicatedIpWarmupAttributesRequest#builder()}
     * </p>
     *
     * @param putDedicatedIpWarmupAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutDedicatedIpWarmupAttributesRequest.Builder} to
     *        create a request. A request to change the warm-up attributes for a dedicated IP address. This operation is
     *        useful when you want to resume the warm-up process for an existing IP address.
     * @return A Java Future containing the result of the PutDedicatedIpWarmupAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDedicatedIpWarmupAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDedicatedIpWarmupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDedicatedIpWarmupAttributesResponse> putDedicatedIpWarmupAttributes(
            Consumer<PutDedicatedIpWarmupAttributesRequest.Builder> putDedicatedIpWarmupAttributesRequest) {
        return putDedicatedIpWarmupAttributes(PutDedicatedIpWarmupAttributesRequest.builder()
                .applyMutation(putDedicatedIpWarmupAttributesRequest).build());
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a
     * Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint
     * Pricing</a>.
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain
     *        access to reputation, deliverability, and other metrics for the domains that you use to send email using
     *        Amazon SES API v2. You also gain the ability to perform predictive inbox placement tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other AWS services. For more information about the features
     *        and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the PutDeliverabilityDashboardOption operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>LimitExceededException There are too many
     *         instances of the specified resource type.</li> <li>BadRequestException The input you provided is invalid.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDeliverabilityDashboardOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(
            PutDeliverabilityDashboardOptionRequest putDeliverabilityDashboardOptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable or disable the Deliverability dashboard. When you enable the Deliverability dashboard, you gain access to
     * reputation, deliverability, and other metrics for the domains that you use to send email. You also gain the
     * ability to perform predictive inbox placement tests.
     * </p>
     * <p>
     * When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other fees
     * that you accrue by using Amazon SES and other AWS services. For more information about the features and cost of a
     * Deliverability dashboard subscription, see <a href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint
     * Pricing</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDeliverabilityDashboardOptionRequest.Builder}
     * avoiding the need to create one manually via {@link PutDeliverabilityDashboardOptionRequest#builder()}
     * </p>
     *
     * @param putDeliverabilityDashboardOptionRequest
     *        A {@link Consumer} that will call methods on {@link PutDeliverabilityDashboardOptionRequest.Builder} to
     *        create a request. Enable or disable the Deliverability dashboard. When you enable the Deliverability
     *        dashboard, you gain access to reputation, deliverability, and other metrics for the domains that you use
     *        to send email using Amazon SES API v2. You also gain the ability to perform predictive inbox placement
     *        tests.</p>
     *        <p>
     *        When you use the Deliverability dashboard, you pay a monthly subscription charge, in addition to any other
     *        fees that you accrue by using Amazon SES and other AWS services. For more information about the features
     *        and cost of a Deliverability dashboard subscription, see <a
     *        href="http://aws.amazon.com/pinpoint/pricing/">Amazon Pinpoint Pricing</a>.
     * @return A Java Future containing the result of the PutDeliverabilityDashboardOption operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AlreadyExistsException The resource specified in your request already exists.</li> <li>
     *         NotFoundException The resource you attempted to access doesn't exist.</li> <li>TooManyRequestsException
     *         Too many requests have been made to the operation.</li> <li>LimitExceededException There are too many
     *         instances of the specified resource type.</li> <li>BadRequestException The input you provided is invalid.
     *         </li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and
     *         client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs
     *         such as an IO related failure, failure to get credentials, etc.</li> <li>SesV2Exception Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutDeliverabilityDashboardOption
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutDeliverabilityDashboardOption"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutDeliverabilityDashboardOptionResponse> putDeliverabilityDashboardOption(
            Consumer<PutDeliverabilityDashboardOptionRequest.Builder> putDeliverabilityDashboardOptionRequest) {
        return putDeliverabilityDashboardOption(PutDeliverabilityDashboardOptionRequest.builder()
                .applyMutation(putDeliverabilityDashboardOptionRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A request to enable or disable DKIM signing of email that you send from an email identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(
            PutEmailIdentityDkimAttributesRequest putEmailIdentityDkimAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable DKIM authentication for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityDkimAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityDkimAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityDkimAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutEmailIdentityDkimAttributesRequest.Builder} to
     *        create a request. A request to enable or disable DKIM signing of email that you send from an email
     *        identity.
     * @return A Java Future containing the result of the PutEmailIdentityDkimAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityDkimAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityDkimAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityDkimAttributesResponse> putEmailIdentityDkimAttributes(
            Consumer<PutEmailIdentityDkimAttributesRequest.Builder> putEmailIdentityDkimAttributesRequest) {
        return putEmailIdentityDkimAttributes(PutEmailIdentityDkimAttributesRequest.builder()
                .applyMutation(putEmailIdentityDkimAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A request to set the attributes that control how bounce and complaint events are processed.
     * @return A Java Future containing the result of the PutEmailIdentityFeedbackAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityFeedbackAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(
            PutEmailIdentityFeedbackAttributesRequest putEmailIdentityFeedbackAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable feedback forwarding for an identity. This setting determines what happens when an
     * identity is used to send an email that results in a bounce or complaint event.
     * </p>
     * <p>
     * If the value is <code>true</code>, you receive email notifications when bounce or complaint events occur. These
     * notifications are sent to the address that you specified in the <code>Return-Path</code> header of the original
     * email.
     * </p>
     * <p>
     * You're required to have a method of tracking bounces and complaints. If you haven't set up another mechanism for
     * receiving bounce or complaint notifications (for example, by setting up an event destination), you receive an
     * email notification when these events occur (even if this setting is disabled).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityFeedbackAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityFeedbackAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityFeedbackAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutEmailIdentityFeedbackAttributesRequest.Builder} to
     *        create a request. A request to set the attributes that control how bounce and complaint events are
     *        processed.
     * @return A Java Future containing the result of the PutEmailIdentityFeedbackAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityFeedbackAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityFeedbackAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityFeedbackAttributesResponse> putEmailIdentityFeedbackAttributes(
            Consumer<PutEmailIdentityFeedbackAttributesRequest.Builder> putEmailIdentityFeedbackAttributesRequest) {
        return putEmailIdentityFeedbackAttributes(PutEmailIdentityFeedbackAttributesRequest.builder()
                .applyMutation(putEmailIdentityFeedbackAttributesRequest).build());
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A request to configure the custom MAIL FROM domain for a verified identity.
     * @return A Java Future containing the result of the PutEmailIdentityMailFromAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityMailFromAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(
            PutEmailIdentityMailFromAttributesRequest putEmailIdentityMailFromAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to enable or disable the custom Mail-From domain configuration for an email identity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEmailIdentityMailFromAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link PutEmailIdentityMailFromAttributesRequest#builder()}
     * </p>
     *
     * @param putEmailIdentityMailFromAttributesRequest
     *        A {@link Consumer} that will call methods on {@link PutEmailIdentityMailFromAttributesRequest.Builder} to
     *        create a request. A request to configure the custom MAIL FROM domain for a verified identity.
     * @return A Java Future containing the result of the PutEmailIdentityMailFromAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.PutEmailIdentityMailFromAttributes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/PutEmailIdentityMailFromAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutEmailIdentityMailFromAttributesResponse> putEmailIdentityMailFromAttributes(
            Consumer<PutEmailIdentityMailFromAttributesRequest.Builder> putEmailIdentityMailFromAttributesRequest) {
        return putEmailIdentityMailFromAttributes(PutEmailIdentityMailFromAttributesRequest.builder()
                .applyMutation(putEmailIdentityMailFromAttributesRequest).build());
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send two types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and the Amazon SES API v2 assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * </ul>
     *
     * @param sendEmailRequest
     *        A request to send an email message.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(SendEmailRequest sendEmailRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends an email message. You can use the Amazon SES API v2 to send two types of messages:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Simple</b> – A standard email message. When you create this type of message, you specify the sender, the
     * recipient, and the message body, and the Amazon SES API v2 assembles the message for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Raw</b> – A raw, MIME-formatted email message. When you send this type of email, you have to specify all of
     * the message headers, as well as the message body. You can use this message type to send messages that contain
     * attachments. The message that you specify has to be a valid MIME message.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEmailRequest.Builder} avoiding the need to
     * create one manually via {@link SendEmailRequest#builder()}
     * </p>
     *
     * @param sendEmailRequest
     *        A {@link Consumer} that will call methods on {@link SendEmailRequest.Builder} to create a request. A
     *        request to send an email message.
     * @return A Java Future containing the result of the SendEmail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>LimitExceededException There are too many instances of the specified resource type.</li>
     *         <li>AccountSuspendedException The message can't be sent because the account's ability to send email has
     *         been permanently restricted.</li>
     *         <li>SendingPausedException The message can't be sent because the account's ability to send email is
     *         currently paused.</li>
     *         <li>MessageRejectedException The message can't be sent because it contains invalid content.</li>
     *         <li>MailFromDomainNotVerifiedException The message can't be sent because the sending domain isn't
     *         verified.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.SendEmail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/SendEmail" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEmailResponse> sendEmail(Consumer<SendEmailRequest.Builder> sendEmailRequest) {
        return sendEmail(SendEmailRequest.builder().applyMutation(sendEmailRequest).build());
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add one or more tags (keys and values) to a specified resource. A <i>tag</i> is a label that you optionally
     * define and associate with a resource. Tags can help you categorize and manage resources in different ways, such
     * as by purpose, owner, environment, or other criteria. A resource can have as many as 50 tags.
     * </p>
     * <p>
     * Each tag consists of a required <i>tag key</i> and an associated <i>tag value</i>, both of which you define. A
     * tag key is a general label that acts as a category for more specific tag values. A tag value acts as a descriptor
     * within a tag key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove one or more tags (keys and values) from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>ConcurrentModificationException The resource is being modified by another operation or thread.</li>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A request to change the settings for an event destination for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            UpdateConfigurationSetEventDestinationRequest updateConfigurationSetEventDestinationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the configuration of an event destination for a configuration set.
     * </p>
     * <p>
     * <i>Events</i> include message sends, deliveries, opens, clicks, bounces, and complaints. <i>Event
     * destinations</i> are places that you can send information about these events to. For example, you can send event
     * data to Amazon SNS to receive notifications when you receive bounces or complaints, or you can use Amazon Kinesis
     * Data Firehose to stream data to Amazon S3 for long-term storage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateConfigurationSetEventDestinationRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateConfigurationSetEventDestinationRequest#builder()}
     * </p>
     *
     * @param updateConfigurationSetEventDestinationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateConfigurationSetEventDestinationRequest.Builder}
     *        to create a request. A request to change the settings for an event destination for a configuration set.
     * @return A Java Future containing the result of the UpdateConfigurationSetEventDestination operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException The resource you attempted to access doesn't exist.</li>
     *         <li>TooManyRequestsException Too many requests have been made to the operation.</li>
     *         <li>BadRequestException The input you provided is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SesV2Exception Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SesV2AsyncClient.UpdateConfigurationSetEventDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/sesv2-2019-09-27/UpdateConfigurationSetEventDestination"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateConfigurationSetEventDestinationResponse> updateConfigurationSetEventDestination(
            Consumer<UpdateConfigurationSetEventDestinationRequest.Builder> updateConfigurationSetEventDestinationRequest) {
        return updateConfigurationSetEventDestination(UpdateConfigurationSetEventDestinationRequest.builder()
                .applyMutation(updateConfigurationSetEventDestinationRequest).build());
    }
}
