/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains inbox placement data for email sent from one of your email domains to a specific email
 * provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainIspPlacement implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainIspPlacement.Builder, DomainIspPlacement> {
    private static final SdkField<String> ISP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DomainIspPlacement::ispName)).setter(setter(Builder::ispName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IspName").build()).build();

    private static final SdkField<Long> INBOX_RAW_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DomainIspPlacement::inboxRawCount)).setter(setter(Builder::inboxRawCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxRawCount").build()).build();

    private static final SdkField<Long> SPAM_RAW_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DomainIspPlacement::spamRawCount)).setter(setter(Builder::spamRawCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamRawCount").build()).build();

    private static final SdkField<Double> INBOX_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DomainIspPlacement::inboxPercentage)).setter(setter(Builder::inboxPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxPercentage").build()).build();

    private static final SdkField<Double> SPAM_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(DomainIspPlacement::spamPercentage)).setter(setter(Builder::spamPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISP_NAME_FIELD,
            INBOX_RAW_COUNT_FIELD, SPAM_RAW_COUNT_FIELD, INBOX_PERCENTAGE_FIELD, SPAM_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ispName;

    private final Long inboxRawCount;

    private final Long spamRawCount;

    private final Double inboxPercentage;

    private final Double spamPercentage;

    private DomainIspPlacement(BuilderImpl builder) {
        this.ispName = builder.ispName;
        this.inboxRawCount = builder.inboxRawCount;
        this.spamRawCount = builder.spamRawCount;
        this.inboxPercentage = builder.inboxPercentage;
        this.spamPercentage = builder.spamPercentage;
    }

    /**
     * <p>
     * The name of the email provider that the inbox placement data applies to.
     * </p>
     * 
     * @return The name of the email provider that the inbox placement data applies to.
     */
    public String ispName() {
        return ispName;
    }

    /**
     * <p>
     * The total number of messages that were sent from the selected domain to the specified email provider that arrived
     * in recipients' inboxes.
     * </p>
     * 
     * @return The total number of messages that were sent from the selected domain to the specified email provider that
     *         arrived in recipients' inboxes.
     */
    public Long inboxRawCount() {
        return inboxRawCount;
    }

    /**
     * <p>
     * The total number of messages that were sent from the selected domain to the specified email provider that arrived
     * in recipients' spam or junk mail folders.
     * </p>
     * 
     * @return The total number of messages that were sent from the selected domain to the specified email provider that
     *         arrived in recipients' spam or junk mail folders.
     */
    public Long spamRawCount() {
        return spamRawCount;
    }

    /**
     * <p>
     * The percentage of messages that were sent from the selected domain to the specified email provider that arrived
     * in recipients' inboxes.
     * </p>
     * 
     * @return The percentage of messages that were sent from the selected domain to the specified email provider that
     *         arrived in recipients' inboxes.
     */
    public Double inboxPercentage() {
        return inboxPercentage;
    }

    /**
     * <p>
     * The percentage of messages that were sent from the selected domain to the specified email provider that arrived
     * in recipients' spam or junk mail folders.
     * </p>
     * 
     * @return The percentage of messages that were sent from the selected domain to the specified email provider that
     *         arrived in recipients' spam or junk mail folders.
     */
    public Double spamPercentage() {
        return spamPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ispName());
        hashCode = 31 * hashCode + Objects.hashCode(inboxRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(spamRawCount());
        hashCode = 31 * hashCode + Objects.hashCode(inboxPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(spamPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainIspPlacement)) {
            return false;
        }
        DomainIspPlacement other = (DomainIspPlacement) obj;
        return Objects.equals(ispName(), other.ispName()) && Objects.equals(inboxRawCount(), other.inboxRawCount())
                && Objects.equals(spamRawCount(), other.spamRawCount())
                && Objects.equals(inboxPercentage(), other.inboxPercentage())
                && Objects.equals(spamPercentage(), other.spamPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainIspPlacement").add("IspName", ispName()).add("InboxRawCount", inboxRawCount())
                .add("SpamRawCount", spamRawCount()).add("InboxPercentage", inboxPercentage())
                .add("SpamPercentage", spamPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IspName":
            return Optional.ofNullable(clazz.cast(ispName()));
        case "InboxRawCount":
            return Optional.ofNullable(clazz.cast(inboxRawCount()));
        case "SpamRawCount":
            return Optional.ofNullable(clazz.cast(spamRawCount()));
        case "InboxPercentage":
            return Optional.ofNullable(clazz.cast(inboxPercentage()));
        case "SpamPercentage":
            return Optional.ofNullable(clazz.cast(spamPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainIspPlacement, T> g) {
        return obj -> g.apply((DomainIspPlacement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainIspPlacement> {
        /**
         * <p>
         * The name of the email provider that the inbox placement data applies to.
         * </p>
         * 
         * @param ispName
         *        The name of the email provider that the inbox placement data applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ispName(String ispName);

        /**
         * <p>
         * The total number of messages that were sent from the selected domain to the specified email provider that
         * arrived in recipients' inboxes.
         * </p>
         * 
         * @param inboxRawCount
         *        The total number of messages that were sent from the selected domain to the specified email provider
         *        that arrived in recipients' inboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxRawCount(Long inboxRawCount);

        /**
         * <p>
         * The total number of messages that were sent from the selected domain to the specified email provider that
         * arrived in recipients' spam or junk mail folders.
         * </p>
         * 
         * @param spamRawCount
         *        The total number of messages that were sent from the selected domain to the specified email provider
         *        that arrived in recipients' spam or junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spamRawCount(Long spamRawCount);

        /**
         * <p>
         * The percentage of messages that were sent from the selected domain to the specified email provider that
         * arrived in recipients' inboxes.
         * </p>
         * 
         * @param inboxPercentage
         *        The percentage of messages that were sent from the selected domain to the specified email provider
         *        that arrived in recipients' inboxes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxPercentage(Double inboxPercentage);

        /**
         * <p>
         * The percentage of messages that were sent from the selected domain to the specified email provider that
         * arrived in recipients' spam or junk mail folders.
         * </p>
         * 
         * @param spamPercentage
         *        The percentage of messages that were sent from the selected domain to the specified email provider
         *        that arrived in recipients' spam or junk mail folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spamPercentage(Double spamPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String ispName;

        private Long inboxRawCount;

        private Long spamRawCount;

        private Double inboxPercentage;

        private Double spamPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainIspPlacement model) {
            ispName(model.ispName);
            inboxRawCount(model.inboxRawCount);
            spamRawCount(model.spamRawCount);
            inboxPercentage(model.inboxPercentage);
            spamPercentage(model.spamPercentage);
        }

        public final String getIspName() {
            return ispName;
        }

        @Override
        public final Builder ispName(String ispName) {
            this.ispName = ispName;
            return this;
        }

        public final void setIspName(String ispName) {
            this.ispName = ispName;
        }

        public final Long getInboxRawCount() {
            return inboxRawCount;
        }

        @Override
        public final Builder inboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
            return this;
        }

        public final void setInboxRawCount(Long inboxRawCount) {
            this.inboxRawCount = inboxRawCount;
        }

        public final Long getSpamRawCount() {
            return spamRawCount;
        }

        @Override
        public final Builder spamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
            return this;
        }

        public final void setSpamRawCount(Long spamRawCount) {
            this.spamRawCount = spamRawCount;
        }

        public final Double getInboxPercentage() {
            return inboxPercentage;
        }

        @Override
        public final Builder inboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
            return this;
        }

        public final void setInboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
        }

        public final Double getSpamPercentage() {
            return spamPercentage;
        }

        @Override
        public final Builder spamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
            return this;
        }

        public final void setSpamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
        }

        @Override
        public DomainIspPlacement build() {
            return new DomainIspPlacement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
