/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains all the deliverability data for a specific campaign. This data is available for a campaign
 * only if the campaign sent email by using a domain that the Deliverability dashboard is enabled for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainDeliverabilityCampaignResponse extends SesV2Response implements
        ToCopyableBuilder<GetDomainDeliverabilityCampaignResponse.Builder, GetDomainDeliverabilityCampaignResponse> {
    private static final SdkField<DomainDeliverabilityCampaign> DOMAIN_DELIVERABILITY_CAMPAIGN_FIELD = SdkField
            .<DomainDeliverabilityCampaign> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDomainDeliverabilityCampaignResponse::domainDeliverabilityCampaign))
            .setter(setter(Builder::domainDeliverabilityCampaign))
            .constructor(DomainDeliverabilityCampaign::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainDeliverabilityCampaign")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOMAIN_DELIVERABILITY_CAMPAIGN_FIELD));

    private final DomainDeliverabilityCampaign domainDeliverabilityCampaign;

    private GetDomainDeliverabilityCampaignResponse(BuilderImpl builder) {
        super(builder);
        this.domainDeliverabilityCampaign = builder.domainDeliverabilityCampaign;
    }

    /**
     * <p>
     * An object that contains the deliverability data for the campaign.
     * </p>
     * 
     * @return An object that contains the deliverability data for the campaign.
     */
    public DomainDeliverabilityCampaign domainDeliverabilityCampaign() {
        return domainDeliverabilityCampaign;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainDeliverabilityCampaign());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDeliverabilityCampaignResponse)) {
            return false;
        }
        GetDomainDeliverabilityCampaignResponse other = (GetDomainDeliverabilityCampaignResponse) obj;
        return Objects.equals(domainDeliverabilityCampaign(), other.domainDeliverabilityCampaign());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainDeliverabilityCampaignResponse")
                .add("DomainDeliverabilityCampaign", domainDeliverabilityCampaign()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainDeliverabilityCampaign":
            return Optional.ofNullable(clazz.cast(domainDeliverabilityCampaign()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainDeliverabilityCampaignResponse, T> g) {
        return obj -> g.apply((GetDomainDeliverabilityCampaignResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDomainDeliverabilityCampaignResponse> {
        /**
         * <p>
         * An object that contains the deliverability data for the campaign.
         * </p>
         * 
         * @param domainDeliverabilityCampaign
         *        An object that contains the deliverability data for the campaign.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainDeliverabilityCampaign(DomainDeliverabilityCampaign domainDeliverabilityCampaign);

        /**
         * <p>
         * An object that contains the deliverability data for the campaign.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainDeliverabilityCampaign.Builder} avoiding
         * the need to create one manually via {@link DomainDeliverabilityCampaign#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainDeliverabilityCampaign.Builder#build()} is called
         * immediately and its result is passed to {@link #domainDeliverabilityCampaign(DomainDeliverabilityCampaign)}.
         * 
         * @param domainDeliverabilityCampaign
         *        a consumer that will call methods on {@link DomainDeliverabilityCampaign.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainDeliverabilityCampaign(DomainDeliverabilityCampaign)
         */
        default Builder domainDeliverabilityCampaign(Consumer<DomainDeliverabilityCampaign.Builder> domainDeliverabilityCampaign) {
            return domainDeliverabilityCampaign(DomainDeliverabilityCampaign.builder()
                    .applyMutation(domainDeliverabilityCampaign).build());
        }
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private DomainDeliverabilityCampaign domainDeliverabilityCampaign;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDeliverabilityCampaignResponse model) {
            super(model);
            domainDeliverabilityCampaign(model.domainDeliverabilityCampaign);
        }

        public final DomainDeliverabilityCampaign.Builder getDomainDeliverabilityCampaign() {
            return domainDeliverabilityCampaign != null ? domainDeliverabilityCampaign.toBuilder() : null;
        }

        @Override
        public final Builder domainDeliverabilityCampaign(DomainDeliverabilityCampaign domainDeliverabilityCampaign) {
            this.domainDeliverabilityCampaign = domainDeliverabilityCampaign;
            return this;
        }

        public final void setDomainDeliverabilityCampaign(DomainDeliverabilityCampaign.BuilderImpl domainDeliverabilityCampaign) {
            this.domainDeliverabilityCampaign = domainDeliverabilityCampaign != null ? domainDeliverabilityCampaign.build()
                    : null;
        }

        @Override
        public GetDomainDeliverabilityCampaignResponse build() {
            return new GetDomainDeliverabilityCampaignResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
