/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to configure the custom MAIL FROM domain for a verified identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutEmailIdentityMailFromAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutEmailIdentityMailFromAttributesRequest.Builder, PutEmailIdentityMailFromAttributesRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityMailFromAttributesRequest::emailIdentity)).setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityMailFromAttributesRequest::mailFromDomain)).setter(setter(Builder::mailFromDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()).build();

    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutEmailIdentityMailFromAttributesRequest::behaviorOnMxFailureAsString))
            .setter(setter(Builder::behaviorOnMxFailure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMxFailure").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD,
            MAIL_FROM_DOMAIN_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));

    private final String emailIdentity;

    private final String mailFromDomain;

    private final String behaviorOnMxFailure;

    private PutEmailIdentityMailFromAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.mailFromDomain = builder.mailFromDomain;
        this.behaviorOnMxFailure = builder.behaviorOnMxFailure;
    }

    /**
     * <p>
     * The verified email identity that you want to set up the custom MAIL FROM domain for.
     * </p>
     * 
     * @return The verified email identity that you want to set up the custom MAIL FROM domain for.
     */
    public String emailIdentity() {
        return emailIdentity;
    }

    /**
     * <p>
     * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the
     * following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It has to be a subdomain of the verified identity.
     * </p>
     * </li>
     * <li>
     * <p>
     * It can't be used to receive email.
     * </p>
     * </li>
     * <li>
     * <p>
     * It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet
     *         the following criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         It has to be a subdomain of the verified identity.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can't be used to receive email.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding
     *         emails.
     *         </p>
     *         </li>
     */
    public String mailFromDomain() {
        return mailFromDomain;
    }

    /**
     * <p>
     * The action that you want to take if the required MX record isn't found when you send an email. When you set this
     * value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When
     * you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
     * </p>
     * <p>
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     * <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMxFailure} will return {@link BehaviorOnMxFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMxFailureAsString}.
     * </p>
     * 
     * @return The action that you want to take if the required MX record isn't found when you send an email. When you
     *         set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL
     *         FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     *         <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
     *         <p>
     *         These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * @see BehaviorOnMxFailure
     */
    public BehaviorOnMxFailure behaviorOnMxFailure() {
        return BehaviorOnMxFailure.fromValue(behaviorOnMxFailure);
    }

    /**
     * <p>
     * The action that you want to take if the required MX record isn't found when you send an email. When you set this
     * value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM domain. When
     * you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
     * </p>
     * <p>
     * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     * <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #behaviorOnMxFailure} will return {@link BehaviorOnMxFailure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #behaviorOnMxFailureAsString}.
     * </p>
     * 
     * @return The action that you want to take if the required MX record isn't found when you send an email. When you
     *         set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL
     *         FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
     *         <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
     *         <p>
     *         These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
     *         <code>Failed</code>, and <code>TemporaryFailure</code> states.
     * @see BehaviorOnMxFailure
     */
    public String behaviorOnMxFailureAsString() {
        return behaviorOnMxFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(behaviorOnMxFailureAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityMailFromAttributesRequest)) {
            return false;
        }
        PutEmailIdentityMailFromAttributesRequest other = (PutEmailIdentityMailFromAttributesRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity()) && Objects.equals(mailFromDomain(), other.mailFromDomain())
                && Objects.equals(behaviorOnMxFailureAsString(), other.behaviorOnMxFailureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutEmailIdentityMailFromAttributesRequest").add("EmailIdentity", emailIdentity())
                .add("MailFromDomain", mailFromDomain()).add("BehaviorOnMxFailure", behaviorOnMxFailureAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        case "MailFromDomain":
            return Optional.ofNullable(clazz.cast(mailFromDomain()));
        case "BehaviorOnMxFailure":
            return Optional.ofNullable(clazz.cast(behaviorOnMxFailureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityMailFromAttributesRequest, T> g) {
        return obj -> g.apply((PutEmailIdentityMailFromAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutEmailIdentityMailFromAttributesRequest> {
        /**
         * <p>
         * The verified email identity that you want to set up the custom MAIL FROM domain for.
         * </p>
         * 
         * @param emailIdentity
         *        The verified email identity that you want to set up the custom MAIL FROM domain for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        /**
         * <p>
         * The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet the
         * following criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It has to be a subdomain of the verified identity.
         * </p>
         * </li>
         * <li>
         * <p>
         * It can't be used to receive email.
         * </p>
         * </li>
         * <li>
         * <p>
         * It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding emails.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mailFromDomain
         *        The custom MAIL FROM domain that you want the verified identity to use. The MAIL FROM domain must meet
         *        the following criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        It has to be a subdomain of the verified identity.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can't be used to receive email.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        It can't be used in a "From" address if the MAIL FROM domain is a destination for feedback forwarding
         *        emails.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailFromDomain(String mailFromDomain);

        /**
         * <p>
         * The action that you want to take if the required MX record isn't found when you send an email. When you set
         * this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM
         * domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
         * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * </p>
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
         * <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMxFailure
         *        The action that you want to take if the required MX record isn't found when you send an email. When
         *        you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
         *        MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns
         *        a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
         *        <p>
         *        These behaviors are taken when the custom MAIL FROM domain configuration is in the
         *        <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @see BehaviorOnMxFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMxFailure
         */
        Builder behaviorOnMxFailure(String behaviorOnMxFailure);

        /**
         * <p>
         * The action that you want to take if the required MX record isn't found when you send an email. When you set
         * this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the MAIL FROM
         * domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns a
         * <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.
         * </p>
         * <p>
         * These behaviors are taken when the custom MAIL FROM domain configuration is in the <code>Pending</code>,
         * <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * </p>
         * 
         * @param behaviorOnMxFailure
         *        The action that you want to take if the required MX record isn't found when you send an email. When
         *        you set this value to <code>UseDefaultValue</code>, the mail is sent using <i>amazonses.com</i> as the
         *        MAIL FROM domain. When you set this value to <code>RejectMessage</code>, the Amazon SES API v2 returns
         *        a <code>MailFromDomainNotVerified</code> error, and doesn't attempt to deliver the email.</p>
         *        <p>
         *        These behaviors are taken when the custom MAIL FROM domain configuration is in the
         *        <code>Pending</code>, <code>Failed</code>, and <code>TemporaryFailure</code> states.
         * @see BehaviorOnMxFailure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BehaviorOnMxFailure
         */
        Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String emailIdentity;

        private String mailFromDomain;

        private String behaviorOnMxFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityMailFromAttributesRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
            mailFromDomain(model.mailFromDomain);
            behaviorOnMxFailure(model.behaviorOnMxFailure);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final String getMailFromDomain() {
            return mailFromDomain;
        }

        @Override
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        public final String getBehaviorOnMxFailureAsString() {
            return behaviorOnMxFailure;
        }

        @Override
        public final Builder behaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
            return this;
        }

        @Override
        public final Builder behaviorOnMxFailure(BehaviorOnMxFailure behaviorOnMxFailure) {
            this.behaviorOnMxFailure(behaviorOnMxFailure == null ? null : behaviorOnMxFailure.toString());
            return this;
        }

        public final void setBehaviorOnMxFailure(String behaviorOnMxFailure) {
            this.behaviorOnMxFailure = behaviorOnMxFailure;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEmailIdentityMailFromAttributesRequest build() {
            return new PutEmailIdentityMailFromAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
