/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.DkimStatus;
import software.amazon.awssdk.services.sesv2.model.DnsTokenListCopier;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEmailIdentityDkimSigningAttributesResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesResponse> {
    private static final SdkField<String> DKIM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutEmailIdentityDkimSigningAttributesResponse.getter(PutEmailIdentityDkimSigningAttributesResponse::dkimStatusAsString)).setter(PutEmailIdentityDkimSigningAttributesResponse.setter(Builder::dkimStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimStatus").build()}).build();
    private static final SdkField<List<String>> DKIM_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutEmailIdentityDkimSigningAttributesResponse.getter(PutEmailIdentityDkimSigningAttributesResponse::dkimTokens)).setter(PutEmailIdentityDkimSigningAttributesResponse.setter(Builder::dkimTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimTokens").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DKIM_STATUS_FIELD, DKIM_TOKENS_FIELD));
    private final String dkimStatus;
    private final List<String> dkimTokens;

    private PutEmailIdentityDkimSigningAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.dkimStatus = builder.dkimStatus;
        this.dkimTokens = builder.dkimTokens;
    }

    public DkimStatus dkimStatus() {
        return DkimStatus.fromValue(this.dkimStatus);
    }

    public String dkimStatusAsString() {
        return this.dkimStatus;
    }

    public boolean hasDkimTokens() {
        return this.dkimTokens != null && !(this.dkimTokens instanceof SdkAutoConstructList);
    }

    public List<String> dkimTokens() {
        return this.dkimTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimTokens());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEmailIdentityDkimSigningAttributesResponse)) {
            return false;
        }
        PutEmailIdentityDkimSigningAttributesResponse other = (PutEmailIdentityDkimSigningAttributesResponse)((Object)obj);
        return Objects.equals(this.dkimStatusAsString(), other.dkimStatusAsString()) && Objects.equals(this.dkimTokens(), other.dkimTokens());
    }

    public String toString() {
        return ToString.builder((String)"PutEmailIdentityDkimSigningAttributesResponse").add("DkimStatus", (Object)this.dkimStatusAsString()).add("DkimTokens", this.dkimTokens()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DkimStatus": {
                return Optional.ofNullable(clazz.cast(this.dkimStatusAsString()));
            }
            case "DkimTokens": {
                return Optional.ofNullable(clazz.cast(this.dkimTokens()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEmailIdentityDkimSigningAttributesResponse, T> g) {
        return obj -> g.apply((PutEmailIdentityDkimSigningAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String dkimStatus;
        private List<String> dkimTokens = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEmailIdentityDkimSigningAttributesResponse model) {
            super(model);
            this.dkimStatus(model.dkimStatus);
            this.dkimTokens(model.dkimTokens);
        }

        public final String getDkimStatus() {
            return this.dkimStatus;
        }

        @Override
        public final Builder dkimStatus(String dkimStatus) {
            this.dkimStatus = dkimStatus;
            return this;
        }

        @Override
        public final Builder dkimStatus(DkimStatus dkimStatus) {
            this.dkimStatus(dkimStatus == null ? null : dkimStatus.toString());
            return this;
        }

        public final void setDkimStatus(String dkimStatus) {
            this.dkimStatus = dkimStatus;
        }

        public final Collection<String> getDkimTokens() {
            return this.dkimTokens;
        }

        @Override
        public final Builder dkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = DnsTokenListCopier.copy(dkimTokens);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dkimTokens(String ... dkimTokens) {
            this.dkimTokens(Arrays.asList(dkimTokens));
            return this;
        }

        public final void setDkimTokens(Collection<String> dkimTokens) {
            this.dkimTokens = DnsTokenListCopier.copy(dkimTokens);
        }

        @Override
        public PutEmailIdentityDkimSigningAttributesResponse build() {
            return new PutEmailIdentityDkimSigningAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEmailIdentityDkimSigningAttributesResponse> {
        public Builder dkimStatus(String var1);

        public Builder dkimStatus(DkimStatus var1);

        public Builder dkimTokens(Collection<String> var1);

        public Builder dkimTokens(String ... var1);
    }
}

