/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BulkEmailEntry implements SdkPojo, Serializable, ToCopyableBuilder<BulkEmailEntry.Builder, BulkEmailEntry> {
    private static final SdkField<Destination> DESTINATION_FIELD = SdkField.<Destination> builder(MarshallingType.SDK_POJO)
            .getter(getter(BulkEmailEntry::destination)).setter(setter(Builder::destination)).constructor(Destination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()).build();

    private static final SdkField<List<MessageTag>> REPLACEMENT_TAGS_FIELD = SdkField
            .<List<MessageTag>> builder(MarshallingType.LIST)
            .getter(getter(BulkEmailEntry::replacementTags))
            .setter(setter(Builder::replacementTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReplacementEmailContent> REPLACEMENT_EMAIL_CONTENT_FIELD = SdkField
            .<ReplacementEmailContent> builder(MarshallingType.SDK_POJO).getter(getter(BulkEmailEntry::replacementEmailContent))
            .setter(setter(Builder::replacementEmailContent)).constructor(ReplacementEmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplacementEmailContent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD,
            REPLACEMENT_TAGS_FIELD, REPLACEMENT_EMAIL_CONTENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Destination destination;

    private final List<MessageTag> replacementTags;

    private final ReplacementEmailContent replacementEmailContent;

    private BulkEmailEntry(BuilderImpl builder) {
        this.destination = builder.destination;
        this.replacementTags = builder.replacementTags;
        this.replacementEmailContent = builder.replacementEmailContent;
    }

    /**
     * <p>
     * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
     * </p>
     * <note>
     * <p>
     * Amazon SES does not support the SMTPUTF8 extension, as described in <a
     * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination email
     * address (the part of the email address that precedes the @ sign) may only contain <a
     * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part of
     * an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode, as
     * described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
     * </p>
     * </note>
     * 
     * @return Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <note>
     *         <p>
     *         Amazon SES does not support the SMTPUTF8 extension, as described in <a
     *         href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
     *         email address (the part of the email address that precedes the @ sign) may only contain <a
     *         href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain
     *         part of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using
     *         Punycode, as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
     *         </p>
     */
    public Destination destination() {
        return destination;
    }

    /**
     * Returns true if the ReplacementTags property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReplacementTags() {
        return replacementTags != null && !(replacementTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you define,
     * so that you can publish email sending events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReplacementTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags, in the form of name/value pairs, to apply to an email that you send using the
     *         <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
     *         define, so that you can publish email sending events.
     */
    public List<MessageTag> replacementTags() {
        return replacementTags;
    }

    /**
     * <p>
     * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
     * </p>
     * 
     * @return The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
     */
    public ReplacementEmailContent replacementEmailContent() {
        return replacementEmailContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(replacementTags());
        hashCode = 31 * hashCode + Objects.hashCode(replacementEmailContent());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BulkEmailEntry)) {
            return false;
        }
        BulkEmailEntry other = (BulkEmailEntry) obj;
        return Objects.equals(destination(), other.destination()) && Objects.equals(replacementTags(), other.replacementTags())
                && Objects.equals(replacementEmailContent(), other.replacementEmailContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BulkEmailEntry").add("Destination", destination()).add("ReplacementTags", replacementTags())
                .add("ReplacementEmailContent", replacementEmailContent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "ReplacementTags":
            return Optional.ofNullable(clazz.cast(replacementTags()));
        case "ReplacementEmailContent":
            return Optional.ofNullable(clazz.cast(replacementEmailContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BulkEmailEntry, T> g) {
        return obj -> g.apply((BulkEmailEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BulkEmailEntry> {
        /**
         * <p>
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         * </p>
         * <note>
         * <p>
         * Amazon SES does not support the SMTPUTF8 extension, as described in <a
         * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
         * email address (the part of the email address that precedes the @ sign) may only contain <a
         * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part
         * of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode,
         * as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         * </p>
         * </note>
         * 
         * @param destination
         *        Represents the destination of the message, consisting of To:, CC:, and BCC: fields.</p> <note>
         *        <p>
         *        Amazon SES does not support the SMTPUTF8 extension, as described in <a
         *        href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a
         *        destination email address (the part of the email address that precedes the @ sign) may only contain <a
         *        href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the
         *        domain part of an address (the part after the @ sign) contains non-ASCII characters, they must be
         *        encoded using Punycode, as described in <a
         *        href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(Destination destination);

        /**
         * <p>
         * Represents the destination of the message, consisting of To:, CC:, and BCC: fields.
         * </p>
         * <note>
         * <p>
         * Amazon SES does not support the SMTPUTF8 extension, as described in <a
         * href="https://tools.ietf.org/html/rfc6531">RFC6531</a>. For this reason, the local part of a destination
         * email address (the part of the email address that precedes the @ sign) may only contain <a
         * href="https://en.wikipedia.org/wiki/Email_address#Local-part">7-bit ASCII characters</a>. If the domain part
         * of an address (the part after the @ sign) contains non-ASCII characters, they must be encoded using Punycode,
         * as described in <a href="https://tools.ietf.org/html/rfc3492.html">RFC3492</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link Destination.Builder} avoiding the need
         * to create one manually via {@link Destination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Destination.Builder#build()} is called immediately and its result
         * is passed to {@link #destination(Destination)}.
         * 
         * @param destination
         *        a consumer that will call methods on {@link Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destination(Destination)
         */
        default Builder destination(Consumer<Destination.Builder> destination) {
            return destination(Destination.builder().applyMutation(destination).build());
        }

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that
         *        you define, so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(Collection<MessageTag> replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * 
         * @param replacementTags
         *        A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         *        <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that
         *        you define, so that you can publish email sending events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementTags(MessageTag... replacementTags);

        /**
         * <p>
         * A list of tags, in the form of name/value pairs, to apply to an email that you send using the
         * <code>SendBulkTemplatedEmail</code> operation. Tags correspond to characteristics of the email that you
         * define, so that you can publish email sending events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MessageTag>.Builder} avoiding the need to
         * create one manually via {@link List<MessageTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MessageTag>.Builder#build()} is called immediately and its
         * result is passed to {@link #replacementTags(List<MessageTag>)}.
         * 
         * @param replacementTags
         *        a consumer that will call methods on {@link List<MessageTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementTags(List<MessageTag>)
         */
        Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags);

        /**
         * <p>
         * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * </p>
         * 
         * @param replacementEmailContent
         *        The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementEmailContent(ReplacementEmailContent replacementEmailContent);

        /**
         * <p>
         * The <code>ReplacementEmailContent</code> associated with a <code>BulkEmailEntry</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplacementEmailContent.Builder} avoiding the
         * need to create one manually via {@link ReplacementEmailContent#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplacementEmailContent.Builder#build()} is called immediately
         * and its result is passed to {@link #replacementEmailContent(ReplacementEmailContent)}.
         * 
         * @param replacementEmailContent
         *        a consumer that will call methods on {@link ReplacementEmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replacementEmailContent(ReplacementEmailContent)
         */
        default Builder replacementEmailContent(Consumer<ReplacementEmailContent.Builder> replacementEmailContent) {
            return replacementEmailContent(ReplacementEmailContent.builder().applyMutation(replacementEmailContent).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Destination destination;

        private List<MessageTag> replacementTags = DefaultSdkAutoConstructList.getInstance();

        private ReplacementEmailContent replacementEmailContent;

        private BuilderImpl() {
        }

        private BuilderImpl(BulkEmailEntry model) {
            destination(model.destination);
            replacementTags(model.replacementTags);
            replacementEmailContent(model.replacementEmailContent);
        }

        public final Destination.Builder getDestination() {
            return destination != null ? destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(Destination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(Destination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final Collection<MessageTag.Builder> getReplacementTags() {
            return replacementTags != null ? replacementTags.stream().map(MessageTag::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder replacementTags(Collection<MessageTag> replacementTags) {
            this.replacementTags = MessageTagListCopier.copy(replacementTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(MessageTag... replacementTags) {
            replacementTags(Arrays.asList(replacementTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replacementTags(Consumer<MessageTag.Builder>... replacementTags) {
            replacementTags(Stream.of(replacementTags).map(c -> MessageTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReplacementTags(Collection<MessageTag.BuilderImpl> replacementTags) {
            this.replacementTags = MessageTagListCopier.copyFromBuilder(replacementTags);
        }

        public final ReplacementEmailContent.Builder getReplacementEmailContent() {
            return replacementEmailContent != null ? replacementEmailContent.toBuilder() : null;
        }

        @Override
        public final Builder replacementEmailContent(ReplacementEmailContent replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent;
            return this;
        }

        public final void setReplacementEmailContent(ReplacementEmailContent.BuilderImpl replacementEmailContent) {
            this.replacementEmailContent = replacementEmailContent != null ? replacementEmailContent.build() : null;
        }

        @Override
        public BulkEmailEntry build() {
            return new BulkEmailEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
