/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class BulkEmailEntryResultListCopier {
    static List<BulkEmailEntryResult> copy(Collection<BulkEmailEntryResult> bulkEmailEntryResultListParam) {
        if (bulkEmailEntryResultListParam == null || bulkEmailEntryResultListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<BulkEmailEntryResult> bulkEmailEntryResultListParamCopy = new ArrayList<>(bulkEmailEntryResultListParam);
        return Collections.unmodifiableList(bulkEmailEntryResultListParamCopy);
    }

    static List<BulkEmailEntryResult> copyFromBuilder(
            Collection<? extends BulkEmailEntryResult.Builder> bulkEmailEntryResultListParam) {
        if (bulkEmailEntryResultListParam == null) {
            return null;
        }
        return copy(bulkEmailEntryResultListParam.stream().map(BulkEmailEntryResult.Builder::build).collect(toList()));
    }
}
