/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to create a custom verification email template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomVerificationEmailTemplateRequest extends SesV2Request implements
        ToCopyableBuilder<CreateCustomVerificationEmailTemplateRequest.Builder, CreateCustomVerificationEmailTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::templateName)).setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()).build();

    private static final SdkField<String> FROM_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::fromEmailAddress))
            .setter(setter(Builder::fromEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<String> TEMPLATE_SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::templateSubject))
            .setter(setter(Builder::templateSubject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateSubject").build()).build();

    private static final SdkField<String> TEMPLATE_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::templateContent))
            .setter(setter(Builder::templateContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateContent").build()).build();

    private static final SdkField<String> SUCCESS_REDIRECTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::successRedirectionURL))
            .setter(setter(Builder::successRedirectionURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessRedirectionURL").build())
            .build();

    private static final SdkField<String> FAILURE_REDIRECTION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCustomVerificationEmailTemplateRequest::failureRedirectionURL))
            .setter(setter(Builder::failureRedirectionURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureRedirectionURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, TEMPLATE_SUBJECT_FIELD, TEMPLATE_CONTENT_FIELD, SUCCESS_REDIRECTION_URL_FIELD,
            FAILURE_REDIRECTION_URL_FIELD));

    private final String templateName;

    private final String fromEmailAddress;

    private final String templateSubject;

    private final String templateContent;

    private final String successRedirectionURL;

    private final String failureRedirectionURL;

    private CreateCustomVerificationEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.templateSubject = builder.templateSubject;
        this.templateContent = builder.templateContent;
        this.successRedirectionURL = builder.successRedirectionURL;
        this.failureRedirectionURL = builder.failureRedirectionURL;
    }

    /**
     * <p>
     * The name of the custom verification email template.
     * </p>
     * 
     * @return The name of the custom verification email template.
     */
    public String templateName() {
        return templateName;
    }

    /**
     * <p>
     * The email address that the custom verification email is sent from.
     * </p>
     * 
     * @return The email address that the custom verification email is sent from.
     */
    public String fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The subject line of the custom verification email.
     * </p>
     * 
     * @return The subject line of the custom verification email.
     */
    public String templateSubject() {
        return templateSubject;
    }

    /**
     * <p>
     * The content of the custom verification email. The total size of the email must be less than 10 MB. The message
     * body may contain HTML, with some limitations. For more information, see <a href=
     * "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq"
     * >Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.
     * </p>
     * 
     * @return The content of the custom verification email. The total size of the email must be less than 10 MB. The
     *         message body may contain HTML, with some limitations. For more information, see <a href=
     *         "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq"
     *         >Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.
     */
    public String templateContent() {
        return templateContent;
    }

    /**
     * <p>
     * The URL that the recipient of the verification email is sent to if his or her address is successfully verified.
     * </p>
     * 
     * @return The URL that the recipient of the verification email is sent to if his or her address is successfully
     *         verified.
     */
    public String successRedirectionURL() {
        return successRedirectionURL;
    }

    /**
     * <p>
     * The URL that the recipient of the verification email is sent to if his or her address is not successfully
     * verified.
     * </p>
     * 
     * @return The URL that the recipient of the verification email is sent to if his or her address is not successfully
     *         verified.
     */
    public String failureRedirectionURL() {
        return failureRedirectionURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(templateSubject());
        hashCode = 31 * hashCode + Objects.hashCode(templateContent());
        hashCode = 31 * hashCode + Objects.hashCode(successRedirectionURL());
        hashCode = 31 * hashCode + Objects.hashCode(failureRedirectionURL());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomVerificationEmailTemplateRequest)) {
            return false;
        }
        CreateCustomVerificationEmailTemplateRequest other = (CreateCustomVerificationEmailTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName())
                && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(templateSubject(), other.templateSubject())
                && Objects.equals(templateContent(), other.templateContent())
                && Objects.equals(successRedirectionURL(), other.successRedirectionURL())
                && Objects.equals(failureRedirectionURL(), other.failureRedirectionURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCustomVerificationEmailTemplateRequest").add("TemplateName", templateName())
                .add("FromEmailAddress", fromEmailAddress()).add("TemplateSubject", templateSubject())
                .add("TemplateContent", templateContent()).add("SuccessRedirectionURL", successRedirectionURL())
                .add("FailureRedirectionURL", failureRedirectionURL()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "TemplateSubject":
            return Optional.ofNullable(clazz.cast(templateSubject()));
        case "TemplateContent":
            return Optional.ofNullable(clazz.cast(templateContent()));
        case "SuccessRedirectionURL":
            return Optional.ofNullable(clazz.cast(successRedirectionURL()));
        case "FailureRedirectionURL":
            return Optional.ofNullable(clazz.cast(failureRedirectionURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomVerificationEmailTemplateRequest, T> g) {
        return obj -> g.apply((CreateCustomVerificationEmailTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCustomVerificationEmailTemplateRequest> {
        /**
         * <p>
         * The name of the custom verification email template.
         * </p>
         * 
         * @param templateName
         *        The name of the custom verification email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * The email address that the custom verification email is sent from.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address that the custom verification email is sent from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(String fromEmailAddress);

        /**
         * <p>
         * The subject line of the custom verification email.
         * </p>
         * 
         * @param templateSubject
         *        The subject line of the custom verification email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateSubject(String templateSubject);

        /**
         * <p>
         * The content of the custom verification email. The total size of the email must be less than 10 MB. The
         * message body may contain HTML, with some limitations. For more information, see <a href=
         * "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq"
         * >Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.
         * </p>
         * 
         * @param templateContent
         *        The content of the custom verification email. The total size of the email must be less than 10 MB. The
         *        message body may contain HTML, with some limitations. For more information, see <a href=
         *        "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-verify-address-custom.html#custom-verification-emails-faq"
         *        >Custom Verification Email Frequently Asked Questions</a> in the <i>Amazon SES Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateContent(String templateContent);

        /**
         * <p>
         * The URL that the recipient of the verification email is sent to if his or her address is successfully
         * verified.
         * </p>
         * 
         * @param successRedirectionURL
         *        The URL that the recipient of the verification email is sent to if his or her address is successfully
         *        verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successRedirectionURL(String successRedirectionURL);

        /**
         * <p>
         * The URL that the recipient of the verification email is sent to if his or her address is not successfully
         * verified.
         * </p>
         * 
         * @param failureRedirectionURL
         *        The URL that the recipient of the verification email is sent to if his or her address is not
         *        successfully verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureRedirectionURL(String failureRedirectionURL);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String templateName;

        private String fromEmailAddress;

        private String templateSubject;

        private String templateContent;

        private String successRedirectionURL;

        private String failureRedirectionURL;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomVerificationEmailTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            fromEmailAddress(model.fromEmailAddress);
            templateSubject(model.templateSubject);
            templateContent(model.templateContent);
            successRedirectionURL(model.successRedirectionURL);
            failureRedirectionURL(model.failureRedirectionURL);
        }

        public final String getTemplateName() {
            return templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        public final String getFromEmailAddress() {
            return fromEmailAddress;
        }

        @Override
        public final Builder fromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final void setFromEmailAddress(String fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
        }

        public final String getTemplateSubject() {
            return templateSubject;
        }

        @Override
        public final Builder templateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
            return this;
        }

        public final void setTemplateSubject(String templateSubject) {
            this.templateSubject = templateSubject;
        }

        public final String getTemplateContent() {
            return templateContent;
        }

        @Override
        public final Builder templateContent(String templateContent) {
            this.templateContent = templateContent;
            return this;
        }

        public final void setTemplateContent(String templateContent) {
            this.templateContent = templateContent;
        }

        public final String getSuccessRedirectionURL() {
            return successRedirectionURL;
        }

        @Override
        public final Builder successRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
            return this;
        }

        public final void setSuccessRedirectionURL(String successRedirectionURL) {
            this.successRedirectionURL = successRedirectionURL;
        }

        public final String getFailureRedirectionURL() {
            return failureRedirectionURL;
        }

        @Override
        public final Builder failureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
            return this;
        }

        public final void setFailureRedirectionURL(String failureRedirectionURL) {
            this.failureRedirectionURL = failureRedirectionURL;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomVerificationEmailTemplateRequest build() {
            return new CreateCustomVerificationEmailTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
