/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content of the email, composed of a subject line, an HTML part, and a text-only part.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmailTemplateContent implements SdkPojo, Serializable,
        ToCopyableBuilder<EmailTemplateContent.Builder, EmailTemplateContent> {
    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateContent::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateContent::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> HTML_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EmailTemplateContent::html)).setter(setter(Builder::html))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Html").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBJECT_FIELD, TEXT_FIELD,
            HTML_FIELD));

    private static final long serialVersionUID = 1L;

    private final String subject;

    private final String text;

    private final String html;

    private EmailTemplateContent(BuilderImpl builder) {
        this.subject = builder.subject;
        this.text = builder.text;
        this.html = builder.html;
    }

    /**
     * <p>
     * The subject line of the email.
     * </p>
     * 
     * @return The subject line of the email.
     */
    public String subject() {
        return subject;
    }

    /**
     * <p>
     * The email body that will be visible to recipients whose email clients do not display HTML.
     * </p>
     * 
     * @return The email body that will be visible to recipients whose email clients do not display HTML.
     */
    public String text() {
        return text;
    }

    /**
     * <p>
     * The HTML body of the email.
     * </p>
     * 
     * @return The HTML body of the email.
     */
    public String html() {
        return html;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(html());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailTemplateContent)) {
            return false;
        }
        EmailTemplateContent other = (EmailTemplateContent) obj;
        return Objects.equals(subject(), other.subject()) && Objects.equals(text(), other.text())
                && Objects.equals(html(), other.html());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EmailTemplateContent").add("Subject", subject()).add("Text", text()).add("Html", html()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Html":
            return Optional.ofNullable(clazz.cast(html()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmailTemplateContent, T> g) {
        return obj -> g.apply((EmailTemplateContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmailTemplateContent> {
        /**
         * <p>
         * The subject line of the email.
         * </p>
         * 
         * @param subject
         *        The subject line of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * <p>
         * The email body that will be visible to recipients whose email clients do not display HTML.
         * </p>
         * 
         * @param text
         *        The email body that will be visible to recipients whose email clients do not display HTML.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The HTML body of the email.
         * </p>
         * 
         * @param html
         *        The HTML body of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder html(String html);
    }

    static final class BuilderImpl implements Builder {
        private String subject;

        private String text;

        private String html;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailTemplateContent model) {
            subject(model.subject);
            text(model.text);
            html(model.html);
        }

        public final String getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getHtml() {
            return html;
        }

        @Override
        public final Builder html(String html) {
            this.html = html;
            return this;
        }

        public final void setHtml(String html) {
            this.html = html;
        }

        @Override
        public EmailTemplateContent build() {
            return new EmailTemplateContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
