/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP 200 response if the request succeeds, or an error message if the request fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImportJobResponse extends SesV2Response implements
        ToCopyableBuilder<GetImportJobResponse.Builder, GetImportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetImportJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<ImportDestination> IMPORT_DESTINATION_FIELD = SdkField
            .<ImportDestination> builder(MarshallingType.SDK_POJO).getter(getter(GetImportJobResponse::importDestination))
            .setter(setter(Builder::importDestination)).constructor(ImportDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDestination").build()).build();

    private static final SdkField<ImportDataSource> IMPORT_DATA_SOURCE_FIELD = SdkField
            .<ImportDataSource> builder(MarshallingType.SDK_POJO).getter(getter(GetImportJobResponse::importDataSource))
            .setter(setter(Builder::importDataSource)).constructor(ImportDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportDataSource").build()).build();

    private static final SdkField<FailureInfo> FAILURE_INFO_FIELD = SdkField.<FailureInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetImportJobResponse::failureInfo)).setter(setter(Builder::failureInfo))
            .constructor(FailureInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureInfo").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetImportJobResponse::jobStatusAsString)).setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetImportJobResponse::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetImportJobResponse::completedTimestamp)).setter(setter(Builder::completedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build())
            .build();

    private static final SdkField<Integer> PROCESSED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetImportJobResponse::processedRecordsCount)).setter(setter(Builder::processedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessedRecordsCount").build())
            .build();

    private static final SdkField<Integer> FAILED_RECORDS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetImportJobResponse::failedRecordsCount)).setter(setter(Builder::failedRecordsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            IMPORT_DESTINATION_FIELD, IMPORT_DATA_SOURCE_FIELD, FAILURE_INFO_FIELD, JOB_STATUS_FIELD, CREATED_TIMESTAMP_FIELD,
            COMPLETED_TIMESTAMP_FIELD, PROCESSED_RECORDS_COUNT_FIELD, FAILED_RECORDS_COUNT_FIELD));

    private final String jobId;

    private final ImportDestination importDestination;

    private final ImportDataSource importDataSource;

    private final FailureInfo failureInfo;

    private final String jobStatus;

    private final Instant createdTimestamp;

    private final Instant completedTimestamp;

    private final Integer processedRecordsCount;

    private final Integer failedRecordsCount;

    private GetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.importDestination = builder.importDestination;
        this.importDataSource = builder.importDataSource;
        this.failureInfo = builder.failureInfo;
        this.jobStatus = builder.jobStatus;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.processedRecordsCount = builder.processedRecordsCount;
        this.failedRecordsCount = builder.failedRecordsCount;
    }

    /**
     * <p>
     * A string that represents the import job ID.
     * </p>
     * 
     * @return A string that represents the import job ID.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The destination of the import job.
     * </p>
     * 
     * @return The destination of the import job.
     */
    public ImportDestination importDestination() {
        return importDestination;
    }

    /**
     * <p>
     * The data source of the import job.
     * </p>
     * 
     * @return The data source of the import job.
     */
    public ImportDataSource importDataSource() {
        return importDataSource;
    }

    /**
     * <p>
     * The failure details about an import job.
     * </p>
     * 
     * @return The failure details about an import job.
     */
    public FailureInfo failureInfo() {
        return failureInfo;
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see JobStatus
     */
    public JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * The status of the import job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return The status of the import job.
     * @see JobStatus
     */
    public String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * The time stamp of when the import job was created.
     * </p>
     * 
     * @return The time stamp of when the import job was created.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time stamp of when the import job was completed.
     * </p>
     * 
     * @return The time stamp of when the import job was completed.
     */
    public Instant completedTimestamp() {
        return completedTimestamp;
    }

    /**
     * <p>
     * The current number of records processed.
     * </p>
     * 
     * @return The current number of records processed.
     */
    public Integer processedRecordsCount() {
        return processedRecordsCount;
    }

    /**
     * <p>
     * The number of records that failed processing because of invalid input or other reasons.
     * </p>
     * 
     * @return The number of records that failed processing because of invalid input or other reasons.
     */
    public Integer failedRecordsCount() {
        return failedRecordsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(importDestination());
        hashCode = 31 * hashCode + Objects.hashCode(importDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(failureInfo());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(processedRecordsCount());
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordsCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportJobResponse)) {
            return false;
        }
        GetImportJobResponse other = (GetImportJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(importDestination(), other.importDestination())
                && Objects.equals(importDataSource(), other.importDataSource())
                && Objects.equals(failureInfo(), other.failureInfo())
                && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(completedTimestamp(), other.completedTimestamp())
                && Objects.equals(processedRecordsCount(), other.processedRecordsCount())
                && Objects.equals(failedRecordsCount(), other.failedRecordsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetImportJobResponse").add("JobId", jobId()).add("ImportDestination", importDestination())
                .add("ImportDataSource", importDataSource()).add("FailureInfo", failureInfo())
                .add("JobStatus", jobStatusAsString()).add("CreatedTimestamp", createdTimestamp())
                .add("CompletedTimestamp", completedTimestamp()).add("ProcessedRecordsCount", processedRecordsCount())
                .add("FailedRecordsCount", failedRecordsCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "ImportDestination":
            return Optional.ofNullable(clazz.cast(importDestination()));
        case "ImportDataSource":
            return Optional.ofNullable(clazz.cast(importDataSource()));
        case "FailureInfo":
            return Optional.ofNullable(clazz.cast(failureInfo()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CompletedTimestamp":
            return Optional.ofNullable(clazz.cast(completedTimestamp()));
        case "ProcessedRecordsCount":
            return Optional.ofNullable(clazz.cast(processedRecordsCount()));
        case "FailedRecordsCount":
            return Optional.ofNullable(clazz.cast(failedRecordsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImportJobResponse, T> g) {
        return obj -> g.apply((GetImportJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetImportJobResponse> {
        /**
         * <p>
         * A string that represents the import job ID.
         * </p>
         * 
         * @param jobId
         *        A string that represents the import job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The destination of the import job.
         * </p>
         * 
         * @param importDestination
         *        The destination of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDestination(ImportDestination importDestination);

        /**
         * <p>
         * The destination of the import job.
         * </p>
         * This is a convenience that creates an instance of the {@link ImportDestination.Builder} avoiding the need to
         * create one manually via {@link ImportDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #importDestination(ImportDestination)}.
         * 
         * @param importDestination
         *        a consumer that will call methods on {@link ImportDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDestination(ImportDestination)
         */
        default Builder importDestination(Consumer<ImportDestination.Builder> importDestination) {
            return importDestination(ImportDestination.builder().applyMutation(importDestination).build());
        }

        /**
         * <p>
         * The data source of the import job.
         * </p>
         * 
         * @param importDataSource
         *        The data source of the import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataSource(ImportDataSource importDataSource);

        /**
         * <p>
         * The data source of the import job.
         * </p>
         * This is a convenience that creates an instance of the {@link ImportDataSource.Builder} avoiding the need to
         * create one manually via {@link ImportDataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImportDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #importDataSource(ImportDataSource)}.
         * 
         * @param importDataSource
         *        a consumer that will call methods on {@link ImportDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importDataSource(ImportDataSource)
         */
        default Builder importDataSource(Consumer<ImportDataSource.Builder> importDataSource) {
            return importDataSource(ImportDataSource.builder().applyMutation(importDataSource).build());
        }

        /**
         * <p>
         * The failure details about an import job.
         * </p>
         * 
         * @param failureInfo
         *        The failure details about an import job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureInfo(FailureInfo failureInfo);

        /**
         * <p>
         * The failure details about an import job.
         * </p>
         * This is a convenience that creates an instance of the {@link FailureInfo.Builder} avoiding the need to create
         * one manually via {@link FailureInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link FailureInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #failureInfo(FailureInfo)}.
         * 
         * @param failureInfo
         *        a consumer that will call methods on {@link FailureInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureInfo(FailureInfo)
         */
        default Builder failureInfo(Consumer<FailureInfo.Builder> failureInfo) {
            return failureInfo(FailureInfo.builder().applyMutation(failureInfo).build());
        }

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the import job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * The status of the import job.
         * </p>
         * 
         * @param jobStatus
         *        The status of the import job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * The time stamp of when the import job was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time stamp of when the import job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time stamp of when the import job was completed.
         * </p>
         * 
         * @param completedTimestamp
         *        The time stamp of when the import job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedTimestamp(Instant completedTimestamp);

        /**
         * <p>
         * The current number of records processed.
         * </p>
         * 
         * @param processedRecordsCount
         *        The current number of records processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processedRecordsCount(Integer processedRecordsCount);

        /**
         * <p>
         * The number of records that failed processing because of invalid input or other reasons.
         * </p>
         * 
         * @param failedRecordsCount
         *        The number of records that failed processing because of invalid input or other reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordsCount(Integer failedRecordsCount);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private String jobId;

        private ImportDestination importDestination;

        private ImportDataSource importDataSource;

        private FailureInfo failureInfo;

        private String jobStatus;

        private Instant createdTimestamp;

        private Instant completedTimestamp;

        private Integer processedRecordsCount;

        private Integer failedRecordsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportJobResponse model) {
            super(model);
            jobId(model.jobId);
            importDestination(model.importDestination);
            importDataSource(model.importDataSource);
            failureInfo(model.failureInfo);
            jobStatus(model.jobStatus);
            createdTimestamp(model.createdTimestamp);
            completedTimestamp(model.completedTimestamp);
            processedRecordsCount(model.processedRecordsCount);
            failedRecordsCount(model.failedRecordsCount);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final ImportDestination.Builder getImportDestination() {
            return importDestination != null ? importDestination.toBuilder() : null;
        }

        @Override
        public final Builder importDestination(ImportDestination importDestination) {
            this.importDestination = importDestination;
            return this;
        }

        public final void setImportDestination(ImportDestination.BuilderImpl importDestination) {
            this.importDestination = importDestination != null ? importDestination.build() : null;
        }

        public final ImportDataSource.Builder getImportDataSource() {
            return importDataSource != null ? importDataSource.toBuilder() : null;
        }

        @Override
        public final Builder importDataSource(ImportDataSource importDataSource) {
            this.importDataSource = importDataSource;
            return this;
        }

        public final void setImportDataSource(ImportDataSource.BuilderImpl importDataSource) {
            this.importDataSource = importDataSource != null ? importDataSource.build() : null;
        }

        public final FailureInfo.Builder getFailureInfo() {
            return failureInfo != null ? failureInfo.toBuilder() : null;
        }

        @Override
        public final Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            return this;
        }

        public final void setFailureInfo(FailureInfo.BuilderImpl failureInfo) {
            this.failureInfo = failureInfo != null ? failureInfo.build() : null;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getCompletedTimestamp() {
            return completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        public final Integer getProcessedRecordsCount() {
            return processedRecordsCount;
        }

        @Override
        public final Builder processedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
            return this;
        }

        public final void setProcessedRecordsCount(Integer processedRecordsCount) {
            this.processedRecordsCount = processedRecordsCount;
        }

        public final Integer getFailedRecordsCount() {
            return failedRecordsCount;
        }

        @Override
        public final Builder failedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
            return this;
        }

        public final void setFailedRecordsCount(Integer failedRecordsCount) {
            this.failedRecordsCount = failedRecordsCount;
        }

        @Override
        public GetImportJobResponse build() {
            return new GetImportJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
