/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the resource destination the import job is going to target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportDestination.Builder, ImportDestination> {
    private static final SdkField<SuppressionListDestination> SUPPRESSION_LIST_DESTINATION_FIELD = SdkField
            .<SuppressionListDestination> builder(MarshallingType.SDK_POJO)
            .getter(getter(ImportDestination::suppressionListDestination))
            .setter(setter(Builder::suppressionListDestination))
            .constructor(SuppressionListDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionListDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUPPRESSION_LIST_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SuppressionListDestination suppressionListDestination;

    private ImportDestination(BuilderImpl builder) {
        this.suppressionListDestination = builder.suppressionListDestination;
    }

    /**
     * <p>
     * An object that contains the action of the import job towards suppression list.
     * </p>
     * 
     * @return An object that contains the action of the import job towards suppression list.
     */
    public SuppressionListDestination suppressionListDestination() {
        return suppressionListDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suppressionListDestination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDestination)) {
            return false;
        }
        ImportDestination other = (ImportDestination) obj;
        return Objects.equals(suppressionListDestination(), other.suppressionListDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportDestination").add("SuppressionListDestination", suppressionListDestination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressionListDestination":
            return Optional.ofNullable(clazz.cast(suppressionListDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDestination, T> g) {
        return obj -> g.apply((ImportDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportDestination> {
        /**
         * <p>
         * An object that contains the action of the import job towards suppression list.
         * </p>
         * 
         * @param suppressionListDestination
         *        An object that contains the action of the import job towards suppression list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressionListDestination(SuppressionListDestination suppressionListDestination);

        /**
         * <p>
         * An object that contains the action of the import job towards suppression list.
         * </p>
         * This is a convenience that creates an instance of the {@link SuppressionListDestination.Builder} avoiding the
         * need to create one manually via {@link SuppressionListDestination#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuppressionListDestination.Builder#build()} is called immediately
         * and its result is passed to {@link #suppressionListDestination(SuppressionListDestination)}.
         * 
         * @param suppressionListDestination
         *        a consumer that will call methods on {@link SuppressionListDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suppressionListDestination(SuppressionListDestination)
         */
        default Builder suppressionListDestination(Consumer<SuppressionListDestination.Builder> suppressionListDestination) {
            return suppressionListDestination(SuppressionListDestination.builder().applyMutation(suppressionListDestination)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SuppressionListDestination suppressionListDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDestination model) {
            suppressionListDestination(model.suppressionListDestination);
        }

        public final SuppressionListDestination.Builder getSuppressionListDestination() {
            return suppressionListDestination != null ? suppressionListDestination.toBuilder() : null;
        }

        @Override
        public final Builder suppressionListDestination(SuppressionListDestination suppressionListDestination) {
            this.suppressionListDestination = suppressionListDestination;
            return this;
        }

        public final void setSuppressionListDestination(SuppressionListDestination.BuilderImpl suppressionListDestination) {
            this.suppressionListDestination = suppressionListDestination != null ? suppressionListDestination.build() : null;
        }

        @Override
        public ImportDestination build() {
            return new ImportDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
