/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains inbox placement data for an email provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlacementStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<PlacementStatistics.Builder, PlacementStatistics> {
    private static final SdkField<Double> INBOX_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PlacementStatistics::inboxPercentage)).setter(setter(Builder::inboxPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InboxPercentage").build()).build();

    private static final SdkField<Double> SPAM_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PlacementStatistics::spamPercentage)).setter(setter(Builder::spamPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpamPercentage").build()).build();

    private static final SdkField<Double> MISSING_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PlacementStatistics::missingPercentage)).setter(setter(Builder::missingPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingPercentage").build()).build();

    private static final SdkField<Double> SPF_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PlacementStatistics::spfPercentage)).setter(setter(Builder::spfPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpfPercentage").build()).build();

    private static final SdkField<Double> DKIM_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(PlacementStatistics::dkimPercentage)).setter(setter(Builder::dkimPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INBOX_PERCENTAGE_FIELD,
            SPAM_PERCENTAGE_FIELD, MISSING_PERCENTAGE_FIELD, SPF_PERCENTAGE_FIELD, DKIM_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double inboxPercentage;

    private final Double spamPercentage;

    private final Double missingPercentage;

    private final Double spfPercentage;

    private final Double dkimPercentage;

    private PlacementStatistics(BuilderImpl builder) {
        this.inboxPercentage = builder.inboxPercentage;
        this.spamPercentage = builder.spamPercentage;
        this.missingPercentage = builder.missingPercentage;
        this.spfPercentage = builder.spfPercentage;
        this.dkimPercentage = builder.dkimPercentage;
    }

    /**
     * <p>
     * The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.
     * </p>
     * 
     * @return The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.
     */
    public Double inboxPercentage() {
        return inboxPercentage;
    }

    /**
     * <p>
     * The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive inbox
     * placement test.
     * </p>
     * 
     * @return The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive
     *         inbox placement test.
     */
    public Double spamPercentage() {
        return spamPercentage;
    }

    /**
     * <p>
     * The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox placement
     * test.
     * </p>
     * 
     * @return The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox
     *         placement test.
     */
    public Double missingPercentage() {
        return missingPercentage;
    }

    /**
     * <p>
     * The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the predictive
     * inbox placement test.
     * </p>
     * 
     * @return The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the
     *         predictive inbox placement test.
     */
    public Double spfPercentage() {
        return spfPercentage;
    }

    /**
     * <p>
     * The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the predictive
     * inbox placement test.
     * </p>
     * 
     * @return The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the
     *         predictive inbox placement test.
     */
    public Double dkimPercentage() {
        return dkimPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inboxPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(spamPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(missingPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(spfPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(dkimPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementStatistics)) {
            return false;
        }
        PlacementStatistics other = (PlacementStatistics) obj;
        return Objects.equals(inboxPercentage(), other.inboxPercentage())
                && Objects.equals(spamPercentage(), other.spamPercentage())
                && Objects.equals(missingPercentage(), other.missingPercentage())
                && Objects.equals(spfPercentage(), other.spfPercentage())
                && Objects.equals(dkimPercentage(), other.dkimPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PlacementStatistics").add("InboxPercentage", inboxPercentage())
                .add("SpamPercentage", spamPercentage()).add("MissingPercentage", missingPercentage())
                .add("SpfPercentage", spfPercentage()).add("DkimPercentage", dkimPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InboxPercentage":
            return Optional.ofNullable(clazz.cast(inboxPercentage()));
        case "SpamPercentage":
            return Optional.ofNullable(clazz.cast(spamPercentage()));
        case "MissingPercentage":
            return Optional.ofNullable(clazz.cast(missingPercentage()));
        case "SpfPercentage":
            return Optional.ofNullable(clazz.cast(spfPercentage()));
        case "DkimPercentage":
            return Optional.ofNullable(clazz.cast(dkimPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementStatistics, T> g) {
        return obj -> g.apply((PlacementStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlacementStatistics> {
        /**
         * <p>
         * The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement test.
         * </p>
         * 
         * @param inboxPercentage
         *        The percentage of emails that arrived in recipients' inboxes during the predictive inbox placement
         *        test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inboxPercentage(Double inboxPercentage);

        /**
         * <p>
         * The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive inbox
         * placement test.
         * </p>
         * 
         * @param spamPercentage
         *        The percentage of emails that arrived in recipients' spam or junk mail folders during the predictive
         *        inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spamPercentage(Double spamPercentage);

        /**
         * <p>
         * The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox
         * placement test.
         * </p>
         * 
         * @param missingPercentage
         *        The percentage of emails that didn't arrive in recipients' inboxes at all during the predictive inbox
         *        placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingPercentage(Double missingPercentage);

        /**
         * <p>
         * The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the predictive
         * inbox placement test.
         * </p>
         * 
         * @param spfPercentage
         *        The percentage of emails that were authenticated by using Sender Policy Framework (SPF) during the
         *        predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spfPercentage(Double spfPercentage);

        /**
         * <p>
         * The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the
         * predictive inbox placement test.
         * </p>
         * 
         * @param dkimPercentage
         *        The percentage of emails that were authenticated by using DomainKeys Identified Mail (DKIM) during the
         *        predictive inbox placement test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dkimPercentage(Double dkimPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Double inboxPercentage;

        private Double spamPercentage;

        private Double missingPercentage;

        private Double spfPercentage;

        private Double dkimPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementStatistics model) {
            inboxPercentage(model.inboxPercentage);
            spamPercentage(model.spamPercentage);
            missingPercentage(model.missingPercentage);
            spfPercentage(model.spfPercentage);
            dkimPercentage(model.dkimPercentage);
        }

        public final Double getInboxPercentage() {
            return inboxPercentage;
        }

        @Override
        public final Builder inboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
            return this;
        }

        public final void setInboxPercentage(Double inboxPercentage) {
            this.inboxPercentage = inboxPercentage;
        }

        public final Double getSpamPercentage() {
            return spamPercentage;
        }

        @Override
        public final Builder spamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
            return this;
        }

        public final void setSpamPercentage(Double spamPercentage) {
            this.spamPercentage = spamPercentage;
        }

        public final Double getMissingPercentage() {
            return missingPercentage;
        }

        @Override
        public final Builder missingPercentage(Double missingPercentage) {
            this.missingPercentage = missingPercentage;
            return this;
        }

        public final void setMissingPercentage(Double missingPercentage) {
            this.missingPercentage = missingPercentage;
        }

        public final Double getSpfPercentage() {
            return spfPercentage;
        }

        @Override
        public final Builder spfPercentage(Double spfPercentage) {
            this.spfPercentage = spfPercentage;
            return this;
        }

        public final void setSpfPercentage(Double spfPercentage) {
            this.spfPercentage = spfPercentage;
        }

        public final Double getDkimPercentage() {
            return dkimPercentage;
        }

        @Override
        public final Builder dkimPercentage(Double dkimPercentage) {
            this.dkimPercentage = dkimPercentage;
            return this;
        }

        public final void setDkimPercentage(Double dkimPercentage) {
            this.dkimPercentage = dkimPercentage;
        }

        @Override
        public PlacementStatistics build() {
            return new PlacementStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
