/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update a sending authorization policy for an identity. Sending authorization is an Amazon SES
 * feature that enables you to authorize other senders to use your identities. For information, see the <a href=
 * "https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-identity-owner-tasks-management.html"
 * >Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateEmailIdentityPolicyRequest extends SesV2Request implements
        ToCopyableBuilder<UpdateEmailIdentityPolicyRequest.Builder, UpdateEmailIdentityPolicyRequest> {
    private static final SdkField<String> EMAIL_IDENTITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEmailIdentityPolicyRequest::emailIdentity)).setter(setter(Builder::emailIdentity))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EmailIdentity").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEmailIdentityPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateEmailIdentityPolicyRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_IDENTITY_FIELD,
            POLICY_NAME_FIELD, POLICY_FIELD));

    private final String emailIdentity;

    private final String policyName;

    private final String policy;

    private UpdateEmailIdentityPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.emailIdentity = builder.emailIdentity;
        this.policyName = builder.policyName;
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The email identity for which you want to update policy.
     * </p>
     * 
     * @return The email identity for which you want to update policy.
     */
    public String emailIdentity() {
        return emailIdentity;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * <p>
     * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and
     * underscores.
     * </p>
     * 
     * @return The name of the policy.</p>
     *         <p>
     *         The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and
     *         underscores.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The text of the policy in JSON format. The policy cannot exceed 4 KB.
     * </p>
     * <p>
     * For information about the syntax of sending authorization policies, see the <a
     * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES
     * Developer Guide</a>.
     * </p>
     * 
     * @return The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
     *         <p>
     *         For information about the syntax of sending authorization policies, see the <a
     *         href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon
     *         SES Developer Guide</a>.
     */
    public String policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(emailIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEmailIdentityPolicyRequest)) {
            return false;
        }
        UpdateEmailIdentityPolicyRequest other = (UpdateEmailIdentityPolicyRequest) obj;
        return Objects.equals(emailIdentity(), other.emailIdentity()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateEmailIdentityPolicyRequest").add("EmailIdentity", emailIdentity())
                .add("PolicyName", policyName()).add("Policy", policy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmailIdentity":
            return Optional.ofNullable(clazz.cast(emailIdentity()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEmailIdentityPolicyRequest, T> g) {
        return obj -> g.apply((UpdateEmailIdentityPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateEmailIdentityPolicyRequest> {
        /**
         * <p>
         * The email identity for which you want to update policy.
         * </p>
         * 
         * @param emailIdentity
         *        The email identity for which you want to update policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailIdentity(String emailIdentity);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * <p>
         * The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and
         * underscores.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.</p>
         *        <p>
         *        The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and
         *        underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The text of the policy in JSON format. The policy cannot exceed 4 KB.
         * </p>
         * <p>
         * For information about the syntax of sending authorization policies, see the <a
         * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html">Amazon SES
         * Developer Guide</a>.
         * </p>
         * 
         * @param policy
         *        The text of the policy in JSON format. The policy cannot exceed 4 KB.</p>
         *        <p>
         *        For information about the syntax of sending authorization policies, see the <a
         *        href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html"
         *        >Amazon SES Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String emailIdentity;

        private String policyName;

        private String policy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEmailIdentityPolicyRequest model) {
            super(model);
            emailIdentity(model.emailIdentity);
            policyName(model.policyName);
            policy(model.policy);
        }

        public final String getEmailIdentity() {
            return emailIdentity;
        }

        @Override
        public final Builder emailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
            return this;
        }

        public final void setEmailIdentity(String emailIdentity) {
            this.emailIdentity = emailIdentity;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEmailIdentityPolicyRequest build() {
            return new UpdateEmailIdentityPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
