/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to enable or disable email sending for messages that use this configuration set in the current AWS Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendingOptions implements SdkPojo, Serializable, ToCopyableBuilder<SendingOptions.Builder, SendingOptions> {
    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendingEnabled").getter(getter(SendingOptions::sendingEnabled)).setter(setter(Builder::sendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDING_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean sendingEnabled;

    private SendingOptions(BuilderImpl builder) {
        this.sendingEnabled = builder.sendingEnabled;
    }

    /**
     * <p>
     * If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email sending is
     * disabled for the configuration set.
     * </p>
     * 
     * @return If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email
     *         sending is disabled for the configuration set.
     */
    public Boolean sendingEnabled() {
        return sendingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sendingEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendingOptions)) {
            return false;
        }
        SendingOptions other = (SendingOptions) obj;
        return Objects.equals(sendingEnabled(), other.sendingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendingOptions").add("SendingEnabled", sendingEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SendingEnabled":
            return Optional.ofNullable(clazz.cast(sendingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendingOptions, T> g) {
        return obj -> g.apply((SendingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SendingOptions> {
        /**
         * <p>
         * If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email
         * sending is disabled for the configuration set.
         * </p>
         * 
         * @param sendingEnabled
         *        If <code>true</code>, email sending is enabled for the configuration set. If <code>false</code>, email
         *        sending is disabled for the configuration set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingEnabled(Boolean sendingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean sendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(SendingOptions model) {
            sendingEnabled(model.sendingEnabled);
        }

        public final Boolean getSendingEnabled() {
            return sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        @Override
        public SendingOptions build() {
            return new SendingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
