/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sesv2.model.AdditionalContactEmailAddressesCopier;
import software.amazon.awssdk.services.sesv2.model.ContactLanguage;
import software.amazon.awssdk.services.sesv2.model.MailType;
import software.amazon.awssdk.services.sesv2.model.SesV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAccountDetailsRequest
extends SesV2Request
implements ToCopyableBuilder<Builder, PutAccountDetailsRequest> {
    private static final SdkField<String> MAIL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailType").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::mailTypeAsString)).setter(PutAccountDetailsRequest.setter(Builder::mailType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailType").build()}).build();
    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteURL").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::websiteURL)).setter(PutAccountDetailsRequest.setter(Builder::websiteURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteURL").build()}).build();
    private static final SdkField<String> CONTACT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactLanguage").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::contactLanguageAsString)).setter(PutAccountDetailsRequest.setter(Builder::contactLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactLanguage").build()}).build();
    private static final SdkField<String> USE_CASE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UseCaseDescription").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::useCaseDescription)).setter(PutAccountDetailsRequest.setter(Builder::useCaseDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCaseDescription").build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdditionalContactEmailAddresses").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::additionalContactEmailAddresses)).setter(PutAccountDetailsRequest.setter(Builder::additionalContactEmailAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalContactEmailAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PRODUCTION_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ProductionAccessEnabled").getter(PutAccountDetailsRequest.getter(PutAccountDetailsRequest::productionAccessEnabled)).setter(PutAccountDetailsRequest.setter(Builder::productionAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionAccessEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAIL_TYPE_FIELD, WEBSITE_URL_FIELD, CONTACT_LANGUAGE_FIELD, USE_CASE_DESCRIPTION_FIELD, ADDITIONAL_CONTACT_EMAIL_ADDRESSES_FIELD, PRODUCTION_ACCESS_ENABLED_FIELD));
    private final String mailType;
    private final String websiteURL;
    private final String contactLanguage;
    private final String useCaseDescription;
    private final List<String> additionalContactEmailAddresses;
    private final Boolean productionAccessEnabled;

    private PutAccountDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.mailType = builder.mailType;
        this.websiteURL = builder.websiteURL;
        this.contactLanguage = builder.contactLanguage;
        this.useCaseDescription = builder.useCaseDescription;
        this.additionalContactEmailAddresses = builder.additionalContactEmailAddresses;
        this.productionAccessEnabled = builder.productionAccessEnabled;
    }

    public MailType mailType() {
        return MailType.fromValue(this.mailType);
    }

    public String mailTypeAsString() {
        return this.mailType;
    }

    public String websiteURL() {
        return this.websiteURL;
    }

    public ContactLanguage contactLanguage() {
        return ContactLanguage.fromValue(this.contactLanguage);
    }

    public String contactLanguageAsString() {
        return this.contactLanguage;
    }

    public String useCaseDescription() {
        return this.useCaseDescription;
    }

    public boolean hasAdditionalContactEmailAddresses() {
        return this.additionalContactEmailAddresses != null && !(this.additionalContactEmailAddresses instanceof SdkAutoConstructList);
    }

    public List<String> additionalContactEmailAddresses() {
        return this.additionalContactEmailAddresses;
    }

    public Boolean productionAccessEnabled() {
        return this.productionAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mailTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.useCaseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalContactEmailAddresses() ? this.additionalContactEmailAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.productionAccessEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountDetailsRequest)) {
            return false;
        }
        PutAccountDetailsRequest other = (PutAccountDetailsRequest)((Object)obj);
        return Objects.equals(this.mailTypeAsString(), other.mailTypeAsString()) && Objects.equals(this.websiteURL(), other.websiteURL()) && Objects.equals(this.contactLanguageAsString(), other.contactLanguageAsString()) && Objects.equals(this.useCaseDescription(), other.useCaseDescription()) && this.hasAdditionalContactEmailAddresses() == other.hasAdditionalContactEmailAddresses() && Objects.equals(this.additionalContactEmailAddresses(), other.additionalContactEmailAddresses()) && Objects.equals(this.productionAccessEnabled(), other.productionAccessEnabled());
    }

    public String toString() {
        return ToString.builder((String)"PutAccountDetailsRequest").add("MailType", (Object)this.mailTypeAsString()).add("WebsiteURL", (Object)(this.websiteURL() == null ? null : "*** Sensitive Data Redacted ***")).add("ContactLanguage", (Object)this.contactLanguageAsString()).add("UseCaseDescription", (Object)(this.useCaseDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalContactEmailAddresses", (Object)(this.additionalContactEmailAddresses() == null ? null : "*** Sensitive Data Redacted ***")).add("ProductionAccessEnabled", (Object)this.productionAccessEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MailType": {
                return Optional.ofNullable(clazz.cast(this.mailTypeAsString()));
            }
            case "WebsiteURL": {
                return Optional.ofNullable(clazz.cast(this.websiteURL()));
            }
            case "ContactLanguage": {
                return Optional.ofNullable(clazz.cast(this.contactLanguageAsString()));
            }
            case "UseCaseDescription": {
                return Optional.ofNullable(clazz.cast(this.useCaseDescription()));
            }
            case "AdditionalContactEmailAddresses": {
                return Optional.ofNullable(clazz.cast(this.additionalContactEmailAddresses()));
            }
            case "ProductionAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.productionAccessEnabled()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountDetailsRequest, T> g) {
        return obj -> g.apply((PutAccountDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Request.BuilderImpl
    implements Builder {
        private String mailType;
        private String websiteURL;
        private String contactLanguage;
        private String useCaseDescription;
        private List<String> additionalContactEmailAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean productionAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountDetailsRequest model) {
            super(model);
            this.mailType(model.mailType);
            this.websiteURL(model.websiteURL);
            this.contactLanguage(model.contactLanguage);
            this.useCaseDescription(model.useCaseDescription);
            this.additionalContactEmailAddresses(model.additionalContactEmailAddresses);
            this.productionAccessEnabled(model.productionAccessEnabled);
        }

        public final String getMailType() {
            return this.mailType;
        }

        @Override
        public final Builder mailType(String mailType) {
            this.mailType = mailType;
            return this;
        }

        @Override
        public final Builder mailType(MailType mailType) {
            this.mailType(mailType == null ? null : mailType.toString());
            return this;
        }

        public final void setMailType(String mailType) {
            this.mailType = mailType;
        }

        public final String getWebsiteURL() {
            return this.websiteURL;
        }

        @Override
        public final Builder websiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
            return this;
        }

        public final void setWebsiteURL(String websiteURL) {
            this.websiteURL = websiteURL;
        }

        public final String getContactLanguage() {
            return this.contactLanguage;
        }

        @Override
        public final Builder contactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
            return this;
        }

        @Override
        public final Builder contactLanguage(ContactLanguage contactLanguage) {
            this.contactLanguage(contactLanguage == null ? null : contactLanguage.toString());
            return this;
        }

        public final void setContactLanguage(String contactLanguage) {
            this.contactLanguage = contactLanguage;
        }

        public final String getUseCaseDescription() {
            return this.useCaseDescription;
        }

        @Override
        public final Builder useCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
            return this;
        }

        public final void setUseCaseDescription(String useCaseDescription) {
            this.useCaseDescription = useCaseDescription;
        }

        public final Collection<String> getAdditionalContactEmailAddresses() {
            if (this.additionalContactEmailAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalContactEmailAddresses;
        }

        @Override
        public final Builder additionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalContactEmailAddresses(String ... additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses(Arrays.asList(additionalContactEmailAddresses));
            return this;
        }

        public final void setAdditionalContactEmailAddresses(Collection<String> additionalContactEmailAddresses) {
            this.additionalContactEmailAddresses = AdditionalContactEmailAddressesCopier.copy(additionalContactEmailAddresses);
        }

        public final Boolean getProductionAccessEnabled() {
            return this.productionAccessEnabled;
        }

        @Override
        public final Builder productionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
            return this;
        }

        public final void setProductionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountDetailsRequest build() {
            return new PutAccountDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAccountDetailsRequest> {
        public Builder mailType(String var1);

        public Builder mailType(MailType var1);

        public Builder websiteURL(String var1);

        public Builder contactLanguage(String var1);

        public Builder contactLanguage(ContactLanguage var1);

        public Builder useCaseDescription(String var1);

        public Builder additionalContactEmailAddresses(Collection<String> var1);

        public Builder additionalContactEmailAddresses(String ... var1);

        public Builder productionAccessEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

