/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.SubscriptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopicPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopicPreference> {
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(TopicPreference.getter(TopicPreference::topicName)).setter(TopicPreference.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionStatus").getter(TopicPreference.getter(TopicPreference::subscriptionStatusAsString)).setter(TopicPreference.setter(Builder::subscriptionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_NAME_FIELD, SUBSCRIPTION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String topicName;
    private final String subscriptionStatus;

    private TopicPreference(BuilderImpl builder) {
        this.topicName = builder.topicName;
        this.subscriptionStatus = builder.subscriptionStatus;
    }

    public String topicName() {
        return this.topicName;
    }

    public SubscriptionStatus subscriptionStatus() {
        return SubscriptionStatus.fromValue(this.subscriptionStatus);
    }

    public String subscriptionStatusAsString() {
        return this.subscriptionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicPreference)) {
            return false;
        }
        TopicPreference other = (TopicPreference)obj;
        return Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.subscriptionStatusAsString(), other.subscriptionStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"TopicPreference").add("TopicName", (Object)this.topicName()).add("SubscriptionStatus", (Object)this.subscriptionStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "SubscriptionStatus": {
                return Optional.ofNullable(clazz.cast(this.subscriptionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TopicPreference, T> g) {
        return obj -> g.apply((TopicPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String topicName;
        private String subscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicPreference model) {
            this.topicName(model.topicName);
            this.subscriptionStatus(model.subscriptionStatus);
        }

        public final String getTopicName() {
            return this.topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        public final String getSubscriptionStatus() {
            return this.subscriptionStatus;
        }

        @Override
        public final Builder subscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
            return this;
        }

        @Override
        public final Builder subscriptionStatus(SubscriptionStatus subscriptionStatus) {
            this.subscriptionStatus(subscriptionStatus == null ? null : subscriptionStatus.toString());
            return this;
        }

        public final void setSubscriptionStatus(String subscriptionStatus) {
            this.subscriptionStatus = subscriptionStatus;
        }

        public TopicPreference build() {
            return new TopicPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopicPreference> {
        public Builder topicName(String var1);

        public Builder subscriptionStatus(String var1);

        public Builder subscriptionStatus(SubscriptionStatus var1);
    }
}

