/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the failure details about an import job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureInfo implements SdkPojo, Serializable, ToCopyableBuilder<FailureInfo.Builder, FailureInfo> {
    private static final SdkField<String> FAILED_RECORDS_S3_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedRecordsS3Url").getter(getter(FailureInfo::failedRecordsS3Url))
            .setter(setter(Builder::failedRecordsS3Url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordsS3Url").build())
            .build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(FailureInfo::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_RECORDS_S3_URL_FIELD,
            ERROR_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String failedRecordsS3Url;

    private final String errorMessage;

    private FailureInfo(BuilderImpl builder) {
        this.failedRecordsS3Url = builder.failedRecordsS3Url;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * An Amazon S3 presigned URL that contains all the failed records and related information.
     * </p>
     * 
     * @return An Amazon S3 presigned URL that contains all the failed records and related information.
     */
    public String failedRecordsS3Url() {
        return failedRecordsS3Url;
    }

    /**
     * <p>
     * A message about why the import job failed.
     * </p>
     * 
     * @return A message about why the import job failed.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordsS3Url());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureInfo)) {
            return false;
        }
        FailureInfo other = (FailureInfo) obj;
        return Objects.equals(failedRecordsS3Url(), other.failedRecordsS3Url())
                && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailureInfo").add("FailedRecordsS3Url", failedRecordsS3Url())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedRecordsS3Url":
            return Optional.ofNullable(clazz.cast(failedRecordsS3Url()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureInfo, T> g) {
        return obj -> g.apply((FailureInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureInfo> {
        /**
         * <p>
         * An Amazon S3 presigned URL that contains all the failed records and related information.
         * </p>
         * 
         * @param failedRecordsS3Url
         *        An Amazon S3 presigned URL that contains all the failed records and related information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordsS3Url(String failedRecordsS3Url);

        /**
         * <p>
         * A message about why the import job failed.
         * </p>
         * 
         * @param errorMessage
         *        A message about why the import job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String failedRecordsS3Url;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailureInfo model) {
            failedRecordsS3Url(model.failedRecordsS3Url);
            errorMessage(model.errorMessage);
        }

        public final String getFailedRecordsS3Url() {
            return failedRecordsS3Url;
        }

        @Override
        public final Builder failedRecordsS3Url(String failedRecordsS3Url) {
            this.failedRecordsS3Url = failedRecordsS3Url;
            return this;
        }

        public final void setFailedRecordsS3Url(String failedRecordsS3Url) {
            this.failedRecordsS3Url = failedRecordsS3Url;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public FailureInfo build() {
            return new FailureInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
