/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of the predictive inbox placement test reports that are available for your account, regardless of whether or
 * not those tests are complete.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDeliverabilityTestReportsResponse extends SesV2Response implements
        ToCopyableBuilder<ListDeliverabilityTestReportsResponse.Builder, ListDeliverabilityTestReportsResponse> {
    private static final SdkField<List<DeliverabilityTestReport>> DELIVERABILITY_TEST_REPORTS_FIELD = SdkField
            .<List<DeliverabilityTestReport>> builder(MarshallingType.LIST)
            .memberName("DeliverabilityTestReports")
            .getter(getter(ListDeliverabilityTestReportsResponse::deliverabilityTestReports))
            .setter(setter(Builder::deliverabilityTestReports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverabilityTestReports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeliverabilityTestReport> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeliverabilityTestReport::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDeliverabilityTestReportsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DELIVERABILITY_TEST_REPORTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<DeliverabilityTestReport> deliverabilityTestReports;

    private final String nextToken;

    private ListDeliverabilityTestReportsResponse(BuilderImpl builder) {
        super(builder);
        this.deliverabilityTestReports = builder.deliverabilityTestReports;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the DeliverabilityTestReports property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDeliverabilityTestReports() {
        return deliverabilityTestReports != null && !(deliverabilityTestReports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object that contains a lists of predictive inbox placement tests that you've performed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeliverabilityTestReports()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that contains a lists of predictive inbox placement tests that you've performed.
     */
    public List<DeliverabilityTestReport> deliverabilityTestReports() {
        return deliverabilityTestReports;
    }

    /**
     * <p>
     * A token that indicates that there are additional predictive inbox placement tests to list. To view additional
     * predictive inbox placement tests, issue another request to <code>ListDeliverabilityTestReports</code>, and pass
     * this token in the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return A token that indicates that there are additional predictive inbox placement tests to list. To view
     *         additional predictive inbox placement tests, issue another request to
     *         <code>ListDeliverabilityTestReports</code>, and pass this token in the <code>NextToken</code> parameter.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeliverabilityTestReports() ? deliverabilityTestReports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeliverabilityTestReportsResponse)) {
            return false;
        }
        ListDeliverabilityTestReportsResponse other = (ListDeliverabilityTestReportsResponse) obj;
        return hasDeliverabilityTestReports() == other.hasDeliverabilityTestReports()
                && Objects.equals(deliverabilityTestReports(), other.deliverabilityTestReports())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDeliverabilityTestReportsResponse")
                .add("DeliverabilityTestReports", hasDeliverabilityTestReports() ? deliverabilityTestReports() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliverabilityTestReports":
            return Optional.ofNullable(clazz.cast(deliverabilityTestReports()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeliverabilityTestReportsResponse, T> g) {
        return obj -> g.apply((ListDeliverabilityTestReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDeliverabilityTestReportsResponse> {
        /**
         * <p>
         * An object that contains a lists of predictive inbox placement tests that you've performed.
         * </p>
         * 
         * @param deliverabilityTestReports
         *        An object that contains a lists of predictive inbox placement tests that you've performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverabilityTestReports(Collection<DeliverabilityTestReport> deliverabilityTestReports);

        /**
         * <p>
         * An object that contains a lists of predictive inbox placement tests that you've performed.
         * </p>
         * 
         * @param deliverabilityTestReports
         *        An object that contains a lists of predictive inbox placement tests that you've performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliverabilityTestReports(DeliverabilityTestReport... deliverabilityTestReports);

        /**
         * <p>
         * An object that contains a lists of predictive inbox placement tests that you've performed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeliverabilityTestReport>.Builder} avoiding
         * the need to create one manually via {@link List<DeliverabilityTestReport>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeliverabilityTestReport>.Builder#build()} is called
         * immediately and its result is passed to {@link #deliverabilityTestReports(List<DeliverabilityTestReport>)}.
         * 
         * @param deliverabilityTestReports
         *        a consumer that will call methods on {@link List<DeliverabilityTestReport>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deliverabilityTestReports(List<DeliverabilityTestReport>)
         */
        Builder deliverabilityTestReports(Consumer<DeliverabilityTestReport.Builder>... deliverabilityTestReports);

        /**
         * <p>
         * A token that indicates that there are additional predictive inbox placement tests to list. To view additional
         * predictive inbox placement tests, issue another request to <code>ListDeliverabilityTestReports</code>, and
         * pass this token in the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates that there are additional predictive inbox placement tests to list. To view
         *        additional predictive inbox placement tests, issue another request to
         *        <code>ListDeliverabilityTestReports</code>, and pass this token in the <code>NextToken</code>
         *        parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<DeliverabilityTestReport> deliverabilityTestReports = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeliverabilityTestReportsResponse model) {
            super(model);
            deliverabilityTestReports(model.deliverabilityTestReports);
            nextToken(model.nextToken);
        }

        public final Collection<DeliverabilityTestReport.Builder> getDeliverabilityTestReports() {
            if (deliverabilityTestReports instanceof SdkAutoConstructList) {
                return null;
            }
            return deliverabilityTestReports != null ? deliverabilityTestReports.stream()
                    .map(DeliverabilityTestReport::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deliverabilityTestReports(Collection<DeliverabilityTestReport> deliverabilityTestReports) {
            this.deliverabilityTestReports = DeliverabilityTestReportsCopier.copy(deliverabilityTestReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverabilityTestReports(DeliverabilityTestReport... deliverabilityTestReports) {
            deliverabilityTestReports(Arrays.asList(deliverabilityTestReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliverabilityTestReports(Consumer<DeliverabilityTestReport.Builder>... deliverabilityTestReports) {
            deliverabilityTestReports(Stream.of(deliverabilityTestReports)
                    .map(c -> DeliverabilityTestReport.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeliverabilityTestReports(Collection<DeliverabilityTestReport.BuilderImpl> deliverabilityTestReports) {
            this.deliverabilityTestReports = DeliverabilityTestReportsCopier.copyFromBuilder(deliverabilityTestReports);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeliverabilityTestReportsResponse build() {
            return new ListDeliverabilityTestReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
