/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an email identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityInfo implements SdkPojo, Serializable, ToCopyableBuilder<IdentityInfo.Builder, IdentityInfo> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityType").getter(getter(IdentityInfo::identityTypeAsString)).setter(setter(Builder::identityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()).build();

    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityName").getter(getter(IdentityInfo::identityName)).setter(setter(Builder::identityName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()).build();

    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SendingEnabled").getter(getter(IdentityInfo::sendingEnabled)).setter(setter(Builder::sendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD,
            IDENTITY_NAME_FIELD, SENDING_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityType;

    private final String identityName;

    private final Boolean sendingEnabled;

    private IdentityInfo(BuilderImpl builder) {
        this.identityType = builder.identityType;
        this.identityName = builder.identityName;
        this.sendingEnabled = builder.sendingEnabled;
    }

    /**
     * <p>
     * The email identity type. The identity type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EMAIL_ADDRESS</code> – The identity is an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOMAIN</code> – The identity is a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. The identity type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EMAIL_ADDRESS</code> – The identity is an email address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOMAIN</code> – The identity is a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final IdentityType identityType() {
        return IdentityType.fromValue(identityType);
    }

    /**
     * <p>
     * The email identity type. The identity type can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EMAIL_ADDRESS</code> – The identity is an email address.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DOMAIN</code> – The identity is a domain.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identityType} will
     * return {@link IdentityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #identityTypeAsString}.
     * </p>
     * 
     * @return The email identity type. The identity type can be one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EMAIL_ADDRESS</code> – The identity is an email address.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DOMAIN</code> – The identity is a domain.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
     *         </p>
     *         </li>
     * @see IdentityType
     */
    public final String identityTypeAsString() {
        return identityType;
    }

    /**
     * <p>
     * The address or domain of the identity.
     * </p>
     * 
     * @return The address or domain of the identity.
     */
    public final String identityName() {
        return identityName;
    }

    /**
     * <p>
     * Indicates whether or not you can send email from the identity.
     * </p>
     * <p>
     * An <i>identity</i> is an email address or domain that you send email from. Before you can send email from an
     * identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email from
     * that identity.
     * </p>
     * 
     * @return Indicates whether or not you can send email from the identity.</p>
     *         <p>
     *         An <i>identity</i> is an email address or domain that you send email from. Before you can send email from
     *         an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send
     *         email from that identity.
     */
    public final Boolean sendingEnabled() {
        return sendingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityName());
        hashCode = 31 * hashCode + Objects.hashCode(sendingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityInfo)) {
            return false;
        }
        IdentityInfo other = (IdentityInfo) obj;
        return Objects.equals(identityTypeAsString(), other.identityTypeAsString())
                && Objects.equals(identityName(), other.identityName())
                && Objects.equals(sendingEnabled(), other.sendingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityInfo").add("IdentityType", identityTypeAsString()).add("IdentityName", identityName())
                .add("SendingEnabled", sendingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityType":
            return Optional.ofNullable(clazz.cast(identityTypeAsString()));
        case "IdentityName":
            return Optional.ofNullable(clazz.cast(identityName()));
        case "SendingEnabled":
            return Optional.ofNullable(clazz.cast(sendingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityInfo, T> g) {
        return obj -> g.apply((IdentityInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityInfo> {
        /**
         * <p>
         * The email identity type. The identity type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EMAIL_ADDRESS</code> – The identity is an email address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOMAIN</code> – The identity is a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        The email identity type. The identity type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EMAIL_ADDRESS</code> – The identity is an email address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOMAIN</code> – The identity is a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(String identityType);

        /**
         * <p>
         * The email identity type. The identity type can be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EMAIL_ADDRESS</code> – The identity is an email address.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DOMAIN</code> – The identity is a domain.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
         * </p>
         * </li>
         * </ul>
         * 
         * @param identityType
         *        The email identity type. The identity type can be one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EMAIL_ADDRESS</code> – The identity is an email address.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DOMAIN</code> – The identity is a domain.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MANAGED_DOMAIN</code> – The identity is a domain that is managed by AWS.
         *        </p>
         *        </li>
         * @see IdentityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityType
         */
        Builder identityType(IdentityType identityType);

        /**
         * <p>
         * The address or domain of the identity.
         * </p>
         * 
         * @param identityName
         *        The address or domain of the identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityName(String identityName);

        /**
         * <p>
         * Indicates whether or not you can send email from the identity.
         * </p>
         * <p>
         * An <i>identity</i> is an email address or domain that you send email from. Before you can send email from an
         * identity, you have to demostrate that you own the identity, and that you authorize Amazon SES to send email
         * from that identity.
         * </p>
         * 
         * @param sendingEnabled
         *        Indicates whether or not you can send email from the identity.</p>
         *        <p>
         *        An <i>identity</i> is an email address or domain that you send email from. Before you can send email
         *        from an identity, you have to demostrate that you own the identity, and that you authorize Amazon SES
         *        to send email from that identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendingEnabled(Boolean sendingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String identityType;

        private String identityName;

        private Boolean sendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityInfo model) {
            identityType(model.identityType);
            identityName(model.identityName);
            sendingEnabled(model.sendingEnabled);
        }

        public final String getIdentityType() {
            return identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        public final String getIdentityName() {
            return identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        public final Boolean getSendingEnabled() {
            return sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        @Override
        public IdentityInfo build() {
            return new IdentityInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
