/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.AccountDetails;
import software.amazon.awssdk.services.sesv2.model.SendQuota;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.services.sesv2.model.SuppressionAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetAccountResponse> {
    private static final SdkField<Boolean> DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedIpAutoWarmupEnabled").getter(GetAccountResponse.getter(GetAccountResponse::dedicatedIpAutoWarmupEnabled)).setter(GetAccountResponse.setter(Builder::dedicatedIpAutoWarmupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedIpAutoWarmupEnabled").build()}).build();
    private static final SdkField<String> ENFORCEMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnforcementStatus").getter(GetAccountResponse.getter(GetAccountResponse::enforcementStatus)).setter(GetAccountResponse.setter(Builder::enforcementStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforcementStatus").build()}).build();
    private static final SdkField<Boolean> PRODUCTION_ACCESS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ProductionAccessEnabled").getter(GetAccountResponse.getter(GetAccountResponse::productionAccessEnabled)).setter(GetAccountResponse.setter(Builder::productionAccessEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionAccessEnabled").build()}).build();
    private static final SdkField<SendQuota> SEND_QUOTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SendQuota").getter(GetAccountResponse.getter(GetAccountResponse::sendQuota)).setter(GetAccountResponse.setter(Builder::sendQuota)).constructor(SendQuota::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendQuota").build()}).build();
    private static final SdkField<Boolean> SENDING_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SendingEnabled").getter(GetAccountResponse.getter(GetAccountResponse::sendingEnabled)).setter(GetAccountResponse.setter(Builder::sendingEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendingEnabled").build()}).build();
    private static final SdkField<SuppressionAttributes> SUPPRESSION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SuppressionAttributes").getter(GetAccountResponse.getter(GetAccountResponse::suppressionAttributes)).setter(GetAccountResponse.setter(Builder::suppressionAttributes)).constructor(SuppressionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionAttributes").build()}).build();
    private static final SdkField<AccountDetails> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(GetAccountResponse.getter(GetAccountResponse::details)).setter(GetAccountResponse.setter(Builder::details)).constructor(AccountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_IP_AUTO_WARMUP_ENABLED_FIELD, ENFORCEMENT_STATUS_FIELD, PRODUCTION_ACCESS_ENABLED_FIELD, SEND_QUOTA_FIELD, SENDING_ENABLED_FIELD, SUPPRESSION_ATTRIBUTES_FIELD, DETAILS_FIELD));
    private final Boolean dedicatedIpAutoWarmupEnabled;
    private final String enforcementStatus;
    private final Boolean productionAccessEnabled;
    private final SendQuota sendQuota;
    private final Boolean sendingEnabled;
    private final SuppressionAttributes suppressionAttributes;
    private final AccountDetails details;

    private GetAccountResponse(BuilderImpl builder) {
        super(builder);
        this.dedicatedIpAutoWarmupEnabled = builder.dedicatedIpAutoWarmupEnabled;
        this.enforcementStatus = builder.enforcementStatus;
        this.productionAccessEnabled = builder.productionAccessEnabled;
        this.sendQuota = builder.sendQuota;
        this.sendingEnabled = builder.sendingEnabled;
        this.suppressionAttributes = builder.suppressionAttributes;
        this.details = builder.details;
    }

    public final Boolean dedicatedIpAutoWarmupEnabled() {
        return this.dedicatedIpAutoWarmupEnabled;
    }

    public final String enforcementStatus() {
        return this.enforcementStatus;
    }

    public final Boolean productionAccessEnabled() {
        return this.productionAccessEnabled;
    }

    public final SendQuota sendQuota() {
        return this.sendQuota;
    }

    public final Boolean sendingEnabled() {
        return this.sendingEnabled;
    }

    public final SuppressionAttributes suppressionAttributes() {
        return this.suppressionAttributes;
    }

    public final AccountDetails details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedIpAutoWarmupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforcementStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.productionAccessEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendQuota());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountResponse)) {
            return false;
        }
        GetAccountResponse other = (GetAccountResponse)((Object)obj);
        return Objects.equals(this.dedicatedIpAutoWarmupEnabled(), other.dedicatedIpAutoWarmupEnabled()) && Objects.equals(this.enforcementStatus(), other.enforcementStatus()) && Objects.equals(this.productionAccessEnabled(), other.productionAccessEnabled()) && Objects.equals(this.sendQuota(), other.sendQuota()) && Objects.equals(this.sendingEnabled(), other.sendingEnabled()) && Objects.equals(this.suppressionAttributes(), other.suppressionAttributes()) && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountResponse").add("DedicatedIpAutoWarmupEnabled", (Object)this.dedicatedIpAutoWarmupEnabled()).add("EnforcementStatus", (Object)this.enforcementStatus()).add("ProductionAccessEnabled", (Object)this.productionAccessEnabled()).add("SendQuota", (Object)this.sendQuota()).add("SendingEnabled", (Object)this.sendingEnabled()).add("SuppressionAttributes", (Object)this.suppressionAttributes()).add("Details", (Object)this.details()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DedicatedIpAutoWarmupEnabled": {
                return Optional.ofNullable(clazz.cast(this.dedicatedIpAutoWarmupEnabled()));
            }
            case "EnforcementStatus": {
                return Optional.ofNullable(clazz.cast(this.enforcementStatus()));
            }
            case "ProductionAccessEnabled": {
                return Optional.ofNullable(clazz.cast(this.productionAccessEnabled()));
            }
            case "SendQuota": {
                return Optional.ofNullable(clazz.cast(this.sendQuota()));
            }
            case "SendingEnabled": {
                return Optional.ofNullable(clazz.cast(this.sendingEnabled()));
            }
            case "SuppressionAttributes": {
                return Optional.ofNullable(clazz.cast(this.suppressionAttributes()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountResponse, T> g) {
        return obj -> g.apply((GetAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private Boolean dedicatedIpAutoWarmupEnabled;
        private String enforcementStatus;
        private Boolean productionAccessEnabled;
        private SendQuota sendQuota;
        private Boolean sendingEnabled;
        private SuppressionAttributes suppressionAttributes;
        private AccountDetails details;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountResponse model) {
            super(model);
            this.dedicatedIpAutoWarmupEnabled(model.dedicatedIpAutoWarmupEnabled);
            this.enforcementStatus(model.enforcementStatus);
            this.productionAccessEnabled(model.productionAccessEnabled);
            this.sendQuota(model.sendQuota);
            this.sendingEnabled(model.sendingEnabled);
            this.suppressionAttributes(model.suppressionAttributes);
            this.details(model.details);
        }

        public final Boolean getDedicatedIpAutoWarmupEnabled() {
            return this.dedicatedIpAutoWarmupEnabled;
        }

        @Override
        public final Builder dedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
            return this;
        }

        public final void setDedicatedIpAutoWarmupEnabled(Boolean dedicatedIpAutoWarmupEnabled) {
            this.dedicatedIpAutoWarmupEnabled = dedicatedIpAutoWarmupEnabled;
        }

        public final String getEnforcementStatus() {
            return this.enforcementStatus;
        }

        @Override
        public final Builder enforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
            return this;
        }

        public final void setEnforcementStatus(String enforcementStatus) {
            this.enforcementStatus = enforcementStatus;
        }

        public final Boolean getProductionAccessEnabled() {
            return this.productionAccessEnabled;
        }

        @Override
        public final Builder productionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
            return this;
        }

        public final void setProductionAccessEnabled(Boolean productionAccessEnabled) {
            this.productionAccessEnabled = productionAccessEnabled;
        }

        public final SendQuota.Builder getSendQuota() {
            return this.sendQuota != null ? this.sendQuota.toBuilder() : null;
        }

        @Override
        public final Builder sendQuota(SendQuota sendQuota) {
            this.sendQuota = sendQuota;
            return this;
        }

        public final void setSendQuota(SendQuota.BuilderImpl sendQuota) {
            this.sendQuota = sendQuota != null ? sendQuota.build() : null;
        }

        public final Boolean getSendingEnabled() {
            return this.sendingEnabled;
        }

        @Override
        public final Builder sendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
            return this;
        }

        public final void setSendingEnabled(Boolean sendingEnabled) {
            this.sendingEnabled = sendingEnabled;
        }

        public final SuppressionAttributes.Builder getSuppressionAttributes() {
            return this.suppressionAttributes != null ? this.suppressionAttributes.toBuilder() : null;
        }

        @Override
        public final Builder suppressionAttributes(SuppressionAttributes suppressionAttributes) {
            this.suppressionAttributes = suppressionAttributes;
            return this;
        }

        public final void setSuppressionAttributes(SuppressionAttributes.BuilderImpl suppressionAttributes) {
            this.suppressionAttributes = suppressionAttributes != null ? suppressionAttributes.build() : null;
        }

        public final AccountDetails.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        @Override
        public final Builder details(AccountDetails details) {
            this.details = details;
            return this;
        }

        public final void setDetails(AccountDetails.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public GetAccountResponse build() {
            return new GetAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountResponse> {
        public Builder dedicatedIpAutoWarmupEnabled(Boolean var1);

        public Builder enforcementStatus(String var1);

        public Builder productionAccessEnabled(Boolean var1);

        public Builder sendQuota(SendQuota var1);

        default public Builder sendQuota(Consumer<SendQuota.Builder> sendQuota) {
            return this.sendQuota((SendQuota)((SendQuota.Builder)SendQuota.builder().applyMutation(sendQuota)).build());
        }

        public Builder sendingEnabled(Boolean var1);

        public Builder suppressionAttributes(SuppressionAttributes var1);

        default public Builder suppressionAttributes(Consumer<SuppressionAttributes.Builder> suppressionAttributes) {
            return this.suppressionAttributes((SuppressionAttributes)((SuppressionAttributes.Builder)SuppressionAttributes.builder().applyMutation(suppressionAttributes)).build());
        }

        public Builder details(AccountDetails var1);

        default public Builder details(Consumer<AccountDetails.Builder> details) {
            return this.details((AccountDetails)((AccountDetails.Builder)AccountDetails.builder().applyMutation(details)).build());
        }
    }
}

