/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to change your account's suppression preferences.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountSuppressionAttributesRequest extends SesV2Request implements
        ToCopyableBuilder<PutAccountSuppressionAttributesRequest.Builder, PutAccountSuppressionAttributesRequest> {
    private static final SdkField<List<String>> SUPPRESSED_REASONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SuppressedReasons")
            .getter(getter(PutAccountSuppressionAttributesRequest::suppressedReasonsAsStrings))
            .setter(setter(Builder::suppressedReasonsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressedReasons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPRESSED_REASONS_FIELD));

    private final List<String> suppressedReasons;

    private PutAccountSuppressionAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.suppressedReasons = builder.suppressedReasons;
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses will be automatically added to the suppression list for
     * your account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuppressedReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses will be automatically added to the suppression list
     *         for your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public final List<SuppressionListReason> suppressedReasons() {
        return SuppressionListReasonsCopier.copyStringToEnum(suppressedReasons);
    }

    /**
     * Returns true if the SuppressedReasons property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSuppressedReasons() {
        return suppressedReasons != null && !(suppressedReasons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains the reasons that email addresses will be automatically added to the suppression list for
     * your account. This list can contain any or all of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a complaint.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a message
     * sent to that address results in a hard bounce.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuppressedReasons()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains the reasons that email addresses will be automatically added to the suppression list
     *         for your account. This list can contain any or all of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a complaint.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
     *         message sent to that address results in a hard bounce.
     *         </p>
     *         </li>
     */
    public final List<String> suppressedReasonsAsStrings() {
        return suppressedReasons;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuppressedReasons() ? suppressedReasonsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountSuppressionAttributesRequest)) {
            return false;
        }
        PutAccountSuppressionAttributesRequest other = (PutAccountSuppressionAttributesRequest) obj;
        return hasSuppressedReasons() == other.hasSuppressedReasons()
                && Objects.equals(suppressedReasonsAsStrings(), other.suppressedReasonsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountSuppressionAttributesRequest")
                .add("SuppressedReasons", hasSuppressedReasons() ? suppressedReasonsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressedReasons":
            return Optional.ofNullable(clazz.cast(suppressedReasonsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountSuppressionAttributesRequest, T> g) {
        return obj -> g.apply((PutAccountSuppressionAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutAccountSuppressionAttributesRequest> {
        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasonsWithStrings(String... suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons);

        /**
         * <p>
         * A list that contains the reasons that email addresses will be automatically added to the suppression list for
         * your account. This list can contain any or all of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a complaint.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         * message sent to that address results in a hard bounce.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressedReasons
         *        A list that contains the reasons that email addresses will be automatically added to the suppression
         *        list for your account. This list can contain any or all of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLAINT</code> – Amazon SES adds an email address to the suppression list for your account
         *        when a message sent to that address results in a complaint.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BOUNCE</code> – Amazon SES adds an email address to the suppression list for your account when a
         *        message sent to that address results in a hard bounce.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressedReasons(SuppressionListReason... suppressedReasons);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private List<String> suppressedReasons = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountSuppressionAttributesRequest model) {
            super(model);
            suppressedReasonsWithStrings(model.suppressedReasons);
        }

        public final Collection<String> getSuppressedReasons() {
            if (suppressedReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return suppressedReasons;
        }

        @Override
        public final Builder suppressedReasonsWithStrings(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasonsWithStrings(String... suppressedReasons) {
            suppressedReasonsWithStrings(Arrays.asList(suppressedReasons));
            return this;
        }

        @Override
        public final Builder suppressedReasons(Collection<SuppressionListReason> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copyEnumToString(suppressedReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suppressedReasons(SuppressionListReason... suppressedReasons) {
            suppressedReasons(Arrays.asList(suppressedReasons));
            return this;
        }

        public final void setSuppressedReasons(Collection<String> suppressedReasons) {
            this.suppressedReasons = SuppressionListReasonsCopier.copy(suppressedReasons);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountSuppressionAttributesRequest build() {
            return new PutAccountSuppressionAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
