/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about blacklist events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBlacklistReportsResponse extends SesV2Response implements
        ToCopyableBuilder<GetBlacklistReportsResponse.Builder, GetBlacklistReportsResponse> {
    private static final SdkField<Map<String, List<BlacklistEntry>>> BLACKLIST_REPORT_FIELD = SdkField
            .<Map<String, List<BlacklistEntry>>> builder(MarshallingType.MAP)
            .memberName("BlacklistReport")
            .getter(getter(GetBlacklistReportsResponse::blacklistReport))
            .setter(setter(Builder::blacklistReport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlacklistReport").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<BlacklistEntry>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<BlacklistEntry> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(BlacklistEntry::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLACKLIST_REPORT_FIELD));

    private final Map<String, List<BlacklistEntry>> blacklistReport;

    private GetBlacklistReportsResponse(BuilderImpl builder) {
        super(builder);
        this.blacklistReport = builder.blacklistReport;
    }

    /**
     * Returns true if the BlacklistReport property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasBlacklistReport() {
        return blacklistReport != null && !(blacklistReport instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that contains information about a blacklist that one of your dedicated IP addresses appears on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBlacklistReport()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An object that contains information about a blacklist that one of your dedicated IP addresses appears on.
     */
    public final Map<String, List<BlacklistEntry>> blacklistReport() {
        return blacklistReport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBlacklistReport() ? blacklistReport() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBlacklistReportsResponse)) {
            return false;
        }
        GetBlacklistReportsResponse other = (GetBlacklistReportsResponse) obj;
        return hasBlacklistReport() == other.hasBlacklistReport() && Objects.equals(blacklistReport(), other.blacklistReport());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBlacklistReportsResponse")
                .add("BlacklistReport", hasBlacklistReport() ? blacklistReport() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlacklistReport":
            return Optional.ofNullable(clazz.cast(blacklistReport()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBlacklistReportsResponse, T> g) {
        return obj -> g.apply((GetBlacklistReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetBlacklistReportsResponse> {
        /**
         * <p>
         * An object that contains information about a blacklist that one of your dedicated IP addresses appears on.
         * </p>
         * 
         * @param blacklistReport
         *        An object that contains information about a blacklist that one of your dedicated IP addresses appears
         *        on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blacklistReport(Map<String, ? extends Collection<BlacklistEntry>> blacklistReport);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private Map<String, List<BlacklistEntry>> blacklistReport = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBlacklistReportsResponse model) {
            super(model);
            blacklistReport(model.blacklistReport);
        }

        public final Map<String, List<BlacklistEntry.Builder>> getBlacklistReport() {
            Map<String, List<BlacklistEntry.Builder>> result = BlacklistReportCopier.copyToBuilder(this.blacklistReport);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blacklistReport(Map<String, ? extends Collection<BlacklistEntry>> blacklistReport) {
            this.blacklistReport = BlacklistReportCopier.copy(blacklistReport);
            return this;
        }

        public final void setBlacklistReport(Map<String, ? extends Collection<BlacklistEntry.BuilderImpl>> blacklistReport) {
            this.blacklistReport = BlacklistReportCopier.copyFromBuilder(blacklistReport);
        }

        @Override
        public GetBlacklistReportsResponse build() {
            return new GetBlacklistReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
