/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An HTTP 200 response if the request succeeds, or an error message if the request fails.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImportJobsResponse extends SesV2Response implements
        ToCopyableBuilder<ListImportJobsResponse.Builder, ListImportJobsResponse> {
    private static final SdkField<List<ImportJobSummary>> IMPORT_JOBS_FIELD = SdkField
            .<List<ImportJobSummary>> builder(MarshallingType.LIST)
            .memberName("ImportJobs")
            .getter(getter(ListImportJobsResponse::importJobs))
            .setter(setter(Builder::importJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListImportJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_JOBS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ImportJobSummary> importJobs;

    private final String nextToken;

    private ListImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.importJobs = builder.importJobs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportJobs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImportJobs() {
        return importJobs != null && !(importJobs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the import job summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportJobs} method.
     * </p>
     * 
     * @return A list of the import job summaries.
     */
    public final List<ImportJobSummary> importJobs() {
        return importJobs;
    }

    /**
     * <p>
     * A string token indicating that there might be additional import jobs available to be listed. Copy this token to a
     * subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of import jobs.
     * </p>
     * 
     * @return A string token indicating that there might be additional import jobs available to be listed. Copy this
     *         token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next
     *         page of import jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImportJobs() ? importJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportJobsResponse)) {
            return false;
        }
        ListImportJobsResponse other = (ListImportJobsResponse) obj;
        return hasImportJobs() == other.hasImportJobs() && Objects.equals(importJobs(), other.importJobs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImportJobsResponse").add("ImportJobs", hasImportJobs() ? importJobs() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImportJobs":
            return Optional.ofNullable(clazz.cast(importJobs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImportJobsResponse, T> g) {
        return obj -> g.apply((ListImportJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Response.Builder, SdkPojo, CopyableBuilder<Builder, ListImportJobsResponse> {
        /**
         * <p>
         * A list of the import job summaries.
         * </p>
         * 
         * @param importJobs
         *        A list of the import job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobs(Collection<ImportJobSummary> importJobs);

        /**
         * <p>
         * A list of the import job summaries.
         * </p>
         * 
         * @param importJobs
         *        A list of the import job summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobs(ImportJobSummary... importJobs);

        /**
         * <p>
         * A list of the import job summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportJobSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ImportJobSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportJobSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #importJobs(List<ImportJobSummary>)}.
         * 
         * @param importJobs
         *        a consumer that will call methods on {@link List<ImportJobSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importJobs(List<ImportJobSummary>)
         */
        Builder importJobs(Consumer<ImportJobSummary.Builder>... importJobs);

        /**
         * <p>
         * A string token indicating that there might be additional import jobs available to be listed. Copy this token
         * to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the next page of
         * import jobs.
         * </p>
         * 
         * @param nextToken
         *        A string token indicating that there might be additional import jobs available to be listed. Copy this
         *        token to a subsequent call to <code>ListImportJobs</code> with the same parameters to retrieve the
         *        next page of import jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SesV2Response.BuilderImpl implements Builder {
        private List<ImportJobSummary> importJobs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportJobsResponse model) {
            super(model);
            importJobs(model.importJobs);
            nextToken(model.nextToken);
        }

        public final List<ImportJobSummary.Builder> getImportJobs() {
            List<ImportJobSummary.Builder> result = ImportJobSummaryListCopier.copyToBuilder(this.importJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportJobs(Collection<ImportJobSummary.BuilderImpl> importJobs) {
            this.importJobs = ImportJobSummaryListCopier.copyFromBuilder(importJobs);
        }

        @Override
        @Transient
        public final Builder importJobs(Collection<ImportJobSummary> importJobs) {
            this.importJobs = ImportJobSummaryListCopier.copy(importJobs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder importJobs(ImportJobSummary... importJobs) {
            importJobs(Arrays.asList(importJobs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder importJobs(Consumer<ImportJobSummary.Builder>... importJobs) {
            importJobs(Stream.of(importJobs).map(c -> ImportJobSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportJobsResponse build() {
            return new ListImportJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
