/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * &gt;Represents a request to create a preview of the MIME content of an email when provided with a template and a set
 * of replacement data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRenderEmailTemplateRequest extends SesV2Request implements
        ToCopyableBuilder<TestRenderEmailTemplateRequest.Builder, TestRenderEmailTemplateRequest> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateName").getter(getter(TestRenderEmailTemplateRequest::templateName))
            .setter(setter(Builder::templateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateName").build()).build();

    private static final SdkField<String> TEMPLATE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateData").getter(getter(TestRenderEmailTemplateRequest::templateData))
            .setter(setter(Builder::templateData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD,
            TEMPLATE_DATA_FIELD));

    private final String templateName;

    private final String templateData;

    private TestRenderEmailTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateName = builder.templateName;
        this.templateData = builder.templateData;
    }

    /**
     * <p>
     * The name of the template that you want to render.
     * </p>
     * 
     * @return The name of the template that you want to render.
     */
    public final String templateName() {
        return templateName;
    }

    /**
     * <p>
     * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting of
     * key-value pairs in which the keys correspond to replacement tags in the email template.
     * </p>
     * 
     * @return A list of replacement values to apply to the template. This parameter is a JSON object, typically
     *         consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
     */
    public final String templateData() {
        return templateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateName());
        hashCode = 31 * hashCode + Objects.hashCode(templateData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRenderEmailTemplateRequest)) {
            return false;
        }
        TestRenderEmailTemplateRequest other = (TestRenderEmailTemplateRequest) obj;
        return Objects.equals(templateName(), other.templateName()) && Objects.equals(templateData(), other.templateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestRenderEmailTemplateRequest").add("TemplateName", templateName())
                .add("TemplateData", templateData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateName":
            return Optional.ofNullable(clazz.cast(templateName()));
        case "TemplateData":
            return Optional.ofNullable(clazz.cast(templateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRenderEmailTemplateRequest, T> g) {
        return obj -> g.apply((TestRenderEmailTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SesV2Request.Builder, SdkPojo, CopyableBuilder<Builder, TestRenderEmailTemplateRequest> {
        /**
         * <p>
         * The name of the template that you want to render.
         * </p>
         * 
         * @param templateName
         *        The name of the template that you want to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateName(String templateName);

        /**
         * <p>
         * A list of replacement values to apply to the template. This parameter is a JSON object, typically consisting
         * of key-value pairs in which the keys correspond to replacement tags in the email template.
         * </p>
         * 
         * @param templateData
         *        A list of replacement values to apply to the template. This parameter is a JSON object, typically
         *        consisting of key-value pairs in which the keys correspond to replacement tags in the email template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateData(String templateData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SesV2Request.BuilderImpl implements Builder {
        private String templateName;

        private String templateData;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRenderEmailTemplateRequest model) {
            super(model);
            templateName(model.templateName);
            templateData(model.templateData);
        }

        public final String getTemplateName() {
            return templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        @Transient
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getTemplateData() {
            return templateData;
        }

        public final void setTemplateData(String templateData) {
            this.templateData = templateData;
        }

        @Override
        @Transient
        public final Builder templateData(String templateData) {
            this.templateData = templateData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestRenderEmailTemplateRequest build() {
            return new TestRenderEmailTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
