/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sesv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains details about the action of suppression list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuppressionListDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<SuppressionListDestination.Builder, SuppressionListDestination> {
    private static final SdkField<String> SUPPRESSION_LIST_IMPORT_ACTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SuppressionListImportAction")
            .getter(getter(SuppressionListDestination::suppressionListImportActionAsString))
            .setter(setter(Builder::suppressionListImportAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuppressionListImportAction")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUPPRESSION_LIST_IMPORT_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String suppressionListImportAction;

    private SuppressionListDestination(BuilderImpl builder) {
        this.suppressionListImportAction = builder.suppressionListImportAction;
    }

    /**
     * <p>
     * The type of action to perform on the address. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT: add the addresses to the suppression list. If the record already exists, it will override it with the new
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE: remove the addresses from the suppression list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #suppressionListImportAction} will return {@link SuppressionListImportAction#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #suppressionListImportActionAsString}.
     * </p>
     * 
     * @return The type of action to perform on the address. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT: add the addresses to the suppression list. If the record already exists, it will override it with
     *         the new value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE: remove the addresses from the suppression list.
     *         </p>
     *         </li>
     * @see SuppressionListImportAction
     */
    public final SuppressionListImportAction suppressionListImportAction() {
        return SuppressionListImportAction.fromValue(suppressionListImportAction);
    }

    /**
     * <p>
     * The type of action to perform on the address. The following are possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PUT: add the addresses to the suppression list. If the record already exists, it will override it with the new
     * value.
     * </p>
     * </li>
     * <li>
     * <p>
     * DELETE: remove the addresses from the suppression list.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #suppressionListImportAction} will return {@link SuppressionListImportAction#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #suppressionListImportActionAsString}.
     * </p>
     * 
     * @return The type of action to perform on the address. The following are possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PUT: add the addresses to the suppression list. If the record already exists, it will override it with
     *         the new value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DELETE: remove the addresses from the suppression list.
     *         </p>
     *         </li>
     * @see SuppressionListImportAction
     */
    public final String suppressionListImportActionAsString() {
        return suppressionListImportAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suppressionListImportActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuppressionListDestination)) {
            return false;
        }
        SuppressionListDestination other = (SuppressionListDestination) obj;
        return Objects.equals(suppressionListImportActionAsString(), other.suppressionListImportActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuppressionListDestination")
                .add("SuppressionListImportAction", suppressionListImportActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SuppressionListImportAction":
            return Optional.ofNullable(clazz.cast(suppressionListImportActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuppressionListDestination, T> g) {
        return obj -> g.apply((SuppressionListDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuppressionListDestination> {
        /**
         * <p>
         * The type of action to perform on the address. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT: add the addresses to the suppression list. If the record already exists, it will override it with the
         * new value.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE: remove the addresses from the suppression list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressionListImportAction
         *        The type of action to perform on the address. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT: add the addresses to the suppression list. If the record already exists, it will override it with
         *        the new value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE: remove the addresses from the suppression list.
         *        </p>
         *        </li>
         * @see SuppressionListImportAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListImportAction
         */
        Builder suppressionListImportAction(String suppressionListImportAction);

        /**
         * <p>
         * The type of action to perform on the address. The following are possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PUT: add the addresses to the suppression list. If the record already exists, it will override it with the
         * new value.
         * </p>
         * </li>
         * <li>
         * <p>
         * DELETE: remove the addresses from the suppression list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param suppressionListImportAction
         *        The type of action to perform on the address. The following are possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PUT: add the addresses to the suppression list. If the record already exists, it will override it with
         *        the new value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DELETE: remove the addresses from the suppression list.
         *        </p>
         *        </li>
         * @see SuppressionListImportAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SuppressionListImportAction
         */
        Builder suppressionListImportAction(SuppressionListImportAction suppressionListImportAction);
    }

    static final class BuilderImpl implements Builder {
        private String suppressionListImportAction;

        private BuilderImpl() {
        }

        private BuilderImpl(SuppressionListDestination model) {
            suppressionListImportAction(model.suppressionListImportAction);
        }

        public final String getSuppressionListImportAction() {
            return suppressionListImportAction;
        }

        public final void setSuppressionListImportAction(String suppressionListImportAction) {
            this.suppressionListImportAction = suppressionListImportAction;
        }

        @Override
        @Transient
        public final Builder suppressionListImportAction(String suppressionListImportAction) {
            this.suppressionListImportAction = suppressionListImportAction;
            return this;
        }

        @Override
        @Transient
        public final Builder suppressionListImportAction(SuppressionListImportAction suppressionListImportAction) {
            this.suppressionListImportAction(suppressionListImportAction == null ? null : suppressionListImportAction.toString());
            return this;
        }

        @Override
        public SuppressionListDestination build() {
            return new SuppressionListDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
