/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Metric {
    SEND("SEND"),
    COMPLAINT("COMPLAINT"),
    PERMANENT_BOUNCE("PERMANENT_BOUNCE"),
    TRANSIENT_BOUNCE("TRANSIENT_BOUNCE"),
    OPEN("OPEN"),
    CLICK("CLICK"),
    DELIVERY("DELIVERY"),
    DELIVERY_OPEN("DELIVERY_OPEN"),
    DELIVERY_CLICK("DELIVERY_CLICK"),
    DELIVERY_COMPLAINT("DELIVERY_COMPLAINT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Metric> VALUE_MAP;
    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Metric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Metric> knownValues() {
        EnumSet<Metric> knownValues = EnumSet.allOf(Metric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Metric.class, Metric::toString);
    }
}

