/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sesv2.SesV2AsyncClient;
import software.amazon.awssdk.services.sesv2.model.ListContactsRequest;
import software.amazon.awssdk.services.sesv2.model.ListContactsResponse;

public class ListContactsPublisher
implements SdkPublisher<ListContactsResponse> {
    private final SesV2AsyncClient client;
    private final ListContactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactsPublisher(SesV2AsyncClient client, ListContactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactsPublisher(SesV2AsyncClient client, ListContactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListContactsResponseFetcher
    implements AsyncPageFetcher<ListContactsResponse> {
        private ListContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactsResponse> nextPage(ListContactsResponse previousPage) {
            if (previousPage == null) {
                return ListContactsPublisher.this.client.listContacts(ListContactsPublisher.this.firstRequest);
            }
            return ListContactsPublisher.this.client.listContacts((ListContactsRequest)((Object)ListContactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

