/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.DkimAttributes;
import software.amazon.awssdk.services.sesv2.model.IdentityType;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEmailIdentityResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, CreateEmailIdentityResponse> {
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(CreateEmailIdentityResponse.getter(CreateEmailIdentityResponse::identityTypeAsString)).setter(CreateEmailIdentityResponse.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<Boolean> VERIFIED_FOR_SENDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VerifiedForSendingStatus").getter(CreateEmailIdentityResponse.getter(CreateEmailIdentityResponse::verifiedForSendingStatus)).setter(CreateEmailIdentityResponse.setter(Builder::verifiedForSendingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedForSendingStatus").build()}).build();
    private static final SdkField<DkimAttributes> DKIM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DkimAttributes").getter(CreateEmailIdentityResponse.getter(CreateEmailIdentityResponse::dkimAttributes)).setter(CreateEmailIdentityResponse.setter(Builder::dkimAttributes)).constructor(DkimAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_TYPE_FIELD, VERIFIED_FOR_SENDING_STATUS_FIELD, DKIM_ATTRIBUTES_FIELD));
    private final String identityType;
    private final Boolean verifiedForSendingStatus;
    private final DkimAttributes dkimAttributes;

    private CreateEmailIdentityResponse(BuilderImpl builder) {
        super(builder);
        this.identityType = builder.identityType;
        this.verifiedForSendingStatus = builder.verifiedForSendingStatus;
        this.dkimAttributes = builder.dkimAttributes;
    }

    public final IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public final String identityTypeAsString() {
        return this.identityType;
    }

    public final Boolean verifiedForSendingStatus() {
        return this.verifiedForSendingStatus;
    }

    public final DkimAttributes dkimAttributes() {
        return this.dkimAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedForSendingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEmailIdentityResponse)) {
            return false;
        }
        CreateEmailIdentityResponse other = (CreateEmailIdentityResponse)((Object)obj);
        return Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.verifiedForSendingStatus(), other.verifiedForSendingStatus()) && Objects.equals(this.dkimAttributes(), other.dkimAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEmailIdentityResponse").add("IdentityType", (Object)this.identityTypeAsString()).add("VerifiedForSendingStatus", (Object)this.verifiedForSendingStatus()).add("DkimAttributes", (Object)this.dkimAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "VerifiedForSendingStatus": {
                return Optional.ofNullable(clazz.cast(this.verifiedForSendingStatus()));
            }
            case "DkimAttributes": {
                return Optional.ofNullable(clazz.cast(this.dkimAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEmailIdentityResponse, T> g) {
        return obj -> g.apply((CreateEmailIdentityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String identityType;
        private Boolean verifiedForSendingStatus;
        private DkimAttributes dkimAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEmailIdentityResponse model) {
            super(model);
            this.identityType(model.identityType);
            this.verifiedForSendingStatus(model.verifiedForSendingStatus);
            this.dkimAttributes(model.dkimAttributes);
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final Boolean getVerifiedForSendingStatus() {
            return this.verifiedForSendingStatus;
        }

        public final void setVerifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
        }

        @Override
        public final Builder verifiedForSendingStatus(Boolean verifiedForSendingStatus) {
            this.verifiedForSendingStatus = verifiedForSendingStatus;
            return this;
        }

        public final DkimAttributes.Builder getDkimAttributes() {
            return this.dkimAttributes != null ? this.dkimAttributes.toBuilder() : null;
        }

        public final void setDkimAttributes(DkimAttributes.BuilderImpl dkimAttributes) {
            this.dkimAttributes = dkimAttributes != null ? dkimAttributes.build() : null;
        }

        @Override
        public final Builder dkimAttributes(DkimAttributes dkimAttributes) {
            this.dkimAttributes = dkimAttributes;
            return this;
        }

        @Override
        public CreateEmailIdentityResponse build() {
            return new CreateEmailIdentityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEmailIdentityResponse> {
        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder verifiedForSendingStatus(Boolean var1);

        public Builder dkimAttributes(DkimAttributes var1);

        default public Builder dkimAttributes(Consumer<DkimAttributes.Builder> dkimAttributes) {
            return this.dkimAttributes((DkimAttributes)((DkimAttributes.Builder)DkimAttributes.builder().applyMutation(dkimAttributes)).build());
        }
    }
}

